/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDBConnMgr;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.AQjmsXASession;

public class AQjmsXAConnection
extends AQjmsConnection
implements XAConnection,
XAQueueConnection,
XATopicConnection {
    private XADataSource m_xaDS;
    private AQjmsXAResourceFactory m_xaresFactory;

    AQjmsXAConnection(String hostname, String oracle_sid, int portno, String username, String password, String jdbc_driver, int type) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(hostname, oracle_sid, portno, username, password, jdbc_driver, true);
        this.initialize(type);
    }

    AQjmsXAConnection(String url, Properties info, int type) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(url, info, true);
        this.initialize(type);
    }

    AQjmsXAConnection(String url, String username, String password, int type) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(url, username, password, true);
        this.initialize(type);
    }

    AQjmsXAConnection(DataSource ds, AQjmsXAResourceFactory xaresFactory, String user, String password, int type) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(ds, user, password);
        this.m_xaresFactory = xaresFactory;
        this.initialize(type);
    }

    AQjmsXAConnection(XADataSource xaDS, String user, String password, int type) throws JMSException {
        this.connMgr = new AQjmsDBConnMgr(xaDS, user, password);
        this.initialize(type);
    }

    public synchronized XASession createXASession() throws JMSException {
        AQjmsXASession xaSess = null;
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXASession", "enter");
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(false);
        try {
            Connection dbConn = genConn.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(dbConn);
            }
            xaSess = new AQjmsXASession(this, 30, genConn, this.m_xaresFactory);
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAConnection.createXASession", ex);
            throw ex;
        }
        finally {
            if (xaSess == null) {
                try {
                    if (genConn != null) {
                        genConn.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXASession", "exit");
        return xaSess;
    }

    public synchronized XAQueueSession createXAQueueSession() throws JMSException {
        AQjmsXASession xaQueueSess = null;
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXAQueueSession", "enter");
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.conn_type != 10) {
            AQjmsError.throwEx(107, this.conn_type == 20 ? "XATopicConnection" : "XAConnection");
        }
        AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(false);
        try {
            Connection dbConn = genConn.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(dbConn);
            }
            xaQueueSess = new AQjmsXASession(this, 10, genConn, this.m_xaresFactory);
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAConnection.createXAQueueSession", ex);
            throw ex;
        }
        finally {
            if (xaQueueSess == null) {
                try {
                    if (genConn != null) {
                        genConn.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXAQueueSession", "exit");
        return xaQueueSess;
    }

    public synchronized XATopicSession createXATopicSession() throws JMSException {
        AQjmsXASession xaTopicSess = null;
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXATopicSession", "enter");
        if (this.isClosed()) {
            AQjmsError.throwIllegalStateEx(114, null);
        }
        if (this.conn_type != 20) {
            AQjmsError.throwEx(107, this.conn_type == 10 ? "XAQueueConnection" : "XAConnection");
        }
        AQjmsGeneralDBConnection genConn = this.connMgr.getConnection(false);
        try {
            Connection dbConn = genConn.getDBConnection();
            if (this.connection_id == null) {
                this.setConnectionID(dbConn);
            }
            xaTopicSess = new AQjmsXASession(this, 20, genConn, this.m_xaresFactory);
        }
        catch (JMSException ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAConnection.createXATopicSession", ex);
            throw ex;
        }
        finally {
            if (xaTopicSess == null) {
                try {
                    if (genConn != null) {
                        genConn.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsXAConnection:createXATopicSession", "exit");
        return xaTopicSess;
    }
}

