/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.InitialContext;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleResultSet;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage_C;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsStreamMessage_C;
import oracle.jms.AQjmsTextMessage_C;
import oracle.jms.AQjmsTransformation;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.ORAData;

class AQjmsUtil {
    static final int JAVA_WAIT_NONE = 1000;
    static final int JAVA_WAIT_FOREVER = 0;
    private static final String s_pfx = AQjmsUtil.getHostTimePrefix();
    private static long s_cnt = 0L;

    AQjmsUtil() {
    }

    static String getSystemProperty(String key) {
        final String fkey = key;
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fkey);
            }
        });
        return value;
    }

    static String getSystemProperty(String key, String def) {
        final String fkey = key;
        final String fdef = def;
        String value = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fkey, fdef);
            }
        });
        return value;
    }

    static boolean selectorEquals(String selector1, String selector2) {
        if (selector1 == null) {
            selector1 = "";
        }
        if (selector2 == null) {
            selector2 = "";
        }
        selector1 = selector1.trim();
        selector2 = selector2.trim();
        return selector1.equals(selector2);
    }

    static boolean topicEquals(AQjmsDestination topic1, AQjmsDestination topic2) throws JMSException {
        boolean topicOwnerEquals = AQjmsUtil.stringEqualsNoCase(topic1.getTopicOwner(), topic2.getTopicOwner());
        boolean topicNameEquals = AQjmsUtil.stringEqualsNoCase(topic1.getTopicName(), topic2.getTopicName());
        return topicOwnerEquals && topicNameEquals;
    }

    static boolean stringEqualsNoCase(String s1, String s2) {
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return s1.equalsIgnoreCase(s2);
    }

    private static String getHostTimePrefix() {
        String host = "localhost";
        String uid = new UID().toString();
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable ex) {
            AQjmsOracleDebug.trace(1, "AQjmsUtil.getHostTimePrefix", "");
        }
        return host + "." + uid;
    }

    static synchronized String newID() {
        return s_pfx + "." + ++s_cnt;
    }

    static String newID(String pfx) {
        return "OJMS." + pfx + "." + AQjmsUtil.newID();
    }

    static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ex) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.sleep", "interrupted");
        }
    }

    static void wait(Object o, long ms) {
        try {
            o.wait(ms);
        }
        catch (InterruptedException ex) {
            AQjmsOracleDebug.trace(5, "WARN: AQjmsUtil.wait", "interrupted");
        }
    }

    static AQjmsObject get(Iterator iter) {
        return (AQjmsObject)((WeakReference)iter.next()).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void sync(Collection s) {
        if (s == null) {
            return;
        }
        Collection collection = s;
        synchronized (collection) {
            Iterator iter = s.iterator();
            while (iter.hasNext()) {
                AQjmsObject c = AQjmsUtil.get(iter);
                if (c != null && c.isOpen()) continue;
                iter.remove();
            }
        }
    }

    static void throwClosed(AQjmsObject o) throws JMSException {
        AQjmsUtil.throwClosed(o, "");
    }

    static void throwClosed(AQjmsObject o, String str) throws JMSException {
        int errcode = o instanceof Connection ? 114 : (o instanceof Session ? 131 : (o instanceof MessageProducer ? 138 : (o instanceof MessageConsumer ? 115 : 122)));
        AQjmsError.throwIllegalStateEx(errcode, str + ":" + o.getID());
    }

    static long javaTimeout(long aqtimeout) {
        if (aqtimeout == 0L) {
            return 1000L;
        }
        if (aqtimeout == -1L) {
            return 0L;
        }
        return aqtimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object lookupObject(String objName, Class objClass) throws JMSException {
        InitialContext ctx = null;
        Object obj = null;
        try {
            ctx = new InitialContext();
            obj = ctx.lookup(objName);
        }
        catch (Exception e) {
            AQjmsError.throwEx(118, (Throwable)e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (Exception e) {}
            }
        }
        if (!objClass.isInstance(obj)) {
            AQjmsError.throwEx(195, objName);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AQjmsTransformation getTransType(java.sql.Connection conn, AQjmsDestination dest, String transfxm) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "entry:" + transfxm);
        if (transfxm == null) {
            AQjmsError.throwEx(122, "transformation is null");
        }
        Statement stmt = null;
        AQjmsTransformation trans = null;
        try {
            String transSchema = null;
            String transName = null;
            int commapos = transfxm.indexOf(".", 1);
            if (commapos == -1) {
                transSchema = ((OracleConnection)conn).getUserName();
                transName = transfxm;
            } else {
                transSchema = transfxm.substring(0, commapos);
                transName = transfxm.substring(commapos + 1);
            }
            AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "schema" + transSchema + " name: " + transName);
            Hashtable transList = dest.getTransTable();
            trans = (AQjmsTransformation)transList.get(transSchema + "." + transName);
            if (trans == null) {
                AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation is not in the cache, retrive from db.");
                stmt = conn.prepareCall("begin dbms_aqjms.aq$_get_trans_type(?, ?, ?, ?);end;");
                stmt.setString(1, transSchema);
                stmt.setString(2, transName);
                stmt.registerOutParameter(3, 12);
                stmt.registerOutParameter(4, 12);
                ResultSet rset = stmt.executeQuery();
                String srcType = stmt.getString(3);
                String destType = stmt.getString(4);
                trans = new AQjmsTransformation(srcType, destType);
                transList.put(transSchema + "." + transName, trans);
            }
        }
        catch (SQLException sqe) {
            String errorMsg = sqe.getErrorCode() == 1403 ? "Transformation " + transfxm + " does not exist" : "Error retrieving transformation types";
            AQjmsError.throwEx(errorMsg, (Throwable)sqe);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsUtil.getTransType", "transformation:" + trans);
        return trans;
    }

    static CLOB populateTextContainer(ORAData cont, AQjmsMessageHeaderExt header, String textData, AQjmsSession sess, boolean useTemporaryLob, boolean[] writeLobFlag) throws JMSException {
        writeLobFlag[0] = false;
        int length = 0;
        if (textData != null) {
            length = textData.length();
        }
        Integer lenField = new Integer(length);
        CLOB lobField = null;
        CLOB tempLob = null;
        String vcField = null;
        boolean pass = false;
        try {
            if (sess.maxBytes(length) > 4000) {
                if (useTemporaryLob) {
                    OracleConnection db_conn = (OracleConnection)sess.getDBConnection();
                    lobField = CLOB.createTemporary((java.sql.Connection)db_conn, (boolean)true, (int)10);
                    lobField.putString(1L, textData);
                    tempLob = lobField;
                } else {
                    lobField = CLOB.empty_lob();
                    writeLobFlag[0] = true;
                }
            } else {
                vcField = textData;
            }
            if (cont instanceof AQjmsGenMessage_C) {
                AQjmsGenMessage_C genCont = (AQjmsGenMessage_C)cont;
                genCont.setMessageType(new Integer(0));
                genCont.setHeader(header);
                genCont.setTextLen(lenField);
                genCont.setTextVc(vcField);
                genCont.setTextLob(lobField);
            } else if (cont instanceof AQjmsTextMessage_C) {
                AQjmsTextMessage_C textCont = (AQjmsTextMessage_C)cont;
                textCont.setHeader(header);
                textCont.setTextLen(lenField);
                textCont.setTextVc(vcField);
                textCont.setTextLob(lobField);
            } else {
                AQjmsError.throwEx(122, "invalid ORAData type:" + cont);
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass && tempLob != null) {
                try {
                    tempLob.freeTemporary();
                }
                catch (Throwable t) {}
            }
        }
        return tempLob;
    }

    static BLOB populateBytesContainer(ORAData cont, int messageType, AQjmsMessageHeaderExt header, byte[] bytesData, AQjmsSession sess, boolean useTemporaryLob, boolean[] writeLobFlag) throws JMSException {
        writeLobFlag[0] = false;
        int length = 0;
        if (bytesData != null) {
            length = bytesData.length;
        }
        Integer lenField = new Integer(length);
        BLOB lobField = null;
        BLOB tempLob = null;
        byte[] rawField = null;
        boolean pass = false;
        try {
            if (length > 2000) {
                if (useTemporaryLob) {
                    OracleConnection db_conn = (OracleConnection)sess.getDBConnection();
                    lobField = BLOB.createTemporary((java.sql.Connection)db_conn, (boolean)true, (int)10);
                    lobField.putBytes(1L, bytesData);
                    tempLob = lobField;
                } else {
                    lobField = BLOB.empty_lob();
                    writeLobFlag[0] = true;
                }
            } else {
                rawField = bytesData;
            }
            if (cont instanceof AQjmsGenMessage_C) {
                AQjmsGenMessage_C genCont = (AQjmsGenMessage_C)cont;
                genCont.setMessageType(new Integer(messageType));
                genCont.setHeader(header);
                genCont.setBytesLen(lenField);
                genCont.setBytesRaw(rawField);
                genCont.setBytesLob(lobField);
            } else if (cont instanceof AQjmsBytesMessage_C) {
                AQjmsBytesMessage_C bytesCont = (AQjmsBytesMessage_C)cont;
                bytesCont.setHeader(header);
                bytesCont.setBytesLen(lenField);
                bytesCont.setBytesRaw(rawField);
                bytesCont.setBytesLob(lobField);
            } else if (cont instanceof AQjmsStreamMessage_C) {
                AQjmsStreamMessage_C streamCont = (AQjmsStreamMessage_C)cont;
                streamCont.setHeader(header);
                streamCont.setBytesLen(lenField);
                streamCont.setBytesRaw(rawField);
                streamCont.setBytesLob(lobField);
            } else if (cont instanceof AQjmsMapMessage_C) {
                AQjmsMapMessage_C mapCont = (AQjmsMapMessage_C)cont;
                mapCont.setHeader(header);
                mapCont.setBytesLen(lenField);
                mapCont.setBytesRaw(rawField);
                mapCont.setBytesLob(lobField);
            } else if (cont instanceof AQjmsObjectMessage_C) {
                AQjmsObjectMessage_C objectCont = (AQjmsObjectMessage_C)cont;
                objectCont.setHeader(header);
                objectCont.setBytesLen(lenField);
                objectCont.setBytesRaw(rawField);
                objectCont.setBytesLob(lobField);
            } else {
                AQjmsError.throwEx(122, "invalid ORAData type:" + cont);
            }
            pass = true;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        finally {
            if (!pass && tempLob != null) {
                try {
                    tempLob.freeTemporary();
                }
                catch (Throwable t) {}
            }
        }
        return tempLob;
    }

    static void writeClob(String textData, AQjmsSession sess, String queueTable, byte[] msgid, boolean isAnydataDest) throws JMSException {
        OracleCallableStatement clobStmt = null;
        try {
            java.sql.Connection db_conn = sess.getDBConnection();
            if (queueTable == null) {
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsUtil.writeClob", "qtable: " + queueTable);
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeClob", "isAnydataDest: " + isAnydataDest);
            if (!isAnydataDest && !sess.isKprb() && (long)textData.length() <= AQjmsConstants.getLongLobThreshold()) {
                clobStmt = (OracleCallableStatement)db_conn.prepareCall("UPDATE " + queueTable + " tab set tab.user_data.text_lob = ? where tab.msgid = ?");
                clobStmt.setString(1, textData);
                clobStmt.setBytes(2, msgid);
                int count = clobStmt.executeUpdate();
                if (count != 1) {
                    AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                }
            } else {
                clobStmt = isAnydataDest ? (OracleCallableStatement)db_conn.prepareCall("SELECT dbms_aqin.aq$_getclob_from_jmsanydata(user_data) FROM " + queueTable + " where msgid = ?") : (OracleCallableStatement)db_conn.prepareCall("SELECT tab.user_data.text_lob FROM " + queueTable + " tab where msgid = ?");
                clobStmt.setBytes(1, msgid);
                ResultSet rset = clobStmt.executeQuery();
                CLOB textLob = null;
                if (rset.next()) {
                    textLob = ((OracleResultSet)rset).getCLOB(1);
                }
                if (textLob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeClob", "Internal error - text_lob is null");
                    AQjmsError.throwEx(122, "text_lob is null");
                }
                textLob.putString(1L, textData);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        finally {
            try {
                if (clobStmt != null) {
                    clobStmt.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    static void writeBlob(byte[] bytesData, AQjmsSession sess, String queueTable, byte[] msgid, boolean isAnydataDest) throws JMSException {
        OracleCallableStatement blobStmt = null;
        try {
            java.sql.Connection db_conn = sess.getDBConnection();
            if (queueTable == null) {
                AQjmsError.throwEx(122, "qtable is null");
            }
            AQjmsOracleDebug.trace(5, "AQjmsUtil.writeBlob", "qtable: " + queueTable);
            AQjmsOracleDebug.trace(5, "AQjmsStreamMessage.writeBlob", "isAnydataDest: " + isAnydataDest);
            if (!isAnydataDest && !sess.isKprb() && (long)bytesData.length <= AQjmsConstants.getLongLobThreshold()) {
                blobStmt = (OracleCallableStatement)db_conn.prepareCall("UPDATE " + queueTable + " tab set tab.user_data.bytes_lob = ? where tab.msgid = ?");
                blobStmt.setBytes(1, bytesData);
                blobStmt.setBytes(2, msgid);
                int count = blobStmt.executeUpdate();
                if (count != 1) {
                    AQjmsError.throwEx(122, "Write lob updated no row or more than 1 row");
                }
            } else {
                blobStmt = isAnydataDest ? (OracleCallableStatement)db_conn.prepareCall("SELECT dbms_aqin.aq$_getblob_from_jmsanydata(user_data) FROM " + queueTable + " where msgid = ?") : (OracleCallableStatement)db_conn.prepareCall("SELECT tab.user_data.bytes_lob FROM " + queueTable + " tab where msgid = ?");
                blobStmt.setBytes(1, msgid);
                ResultSet rset = blobStmt.executeQuery();
                BLOB bytesLob = null;
                if (rset.next()) {
                    bytesLob = ((OracleResultSet)rset).getBLOB(1);
                }
                if (bytesLob == null) {
                    AQjmsOracleDebug.trace(1, "AQjmsUtil.writeBlob", "Internal error - bytes_lob is null");
                    AQjmsError.throwEx(122, "bytes_lob is null");
                }
                bytesLob.putBytes(1L, bytesData);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        finally {
            try {
                if (blobStmt != null) {
                    blobStmt.close();
                }
            }
            catch (Throwable t) {}
        }
    }

    static String getTextData(int textLen, CLOB textLob, String textVc) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getTextData", "textLen: " + textLen);
        String textData = textVc;
        if (textData == null && textLob != null) {
            try {
                textData = textLob.getSubString(1L, textLen);
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
        if (textData == null && textLen != 0 || textData != null && textData.length() != textLen) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getTextData", "exit");
        return textData;
    }

    static byte[] getBytesData(int bytesLen, BLOB bytesLob, byte[] bytesRaw) throws JMSException {
        byte[] bytesData = null;
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsUtil.getBytesData", "bytesLen: " + bytesLen);
        try {
            if (bytesRaw != null) {
                bytesData = bytesRaw;
            } else if (bytesLob != null) {
                bytesData = bytesLob.getBytes(1L, bytesLen);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        if (bytesData == null && bytesLen != 0 || bytesData != null && bytesData.length != bytesLen) {
            AQjmsError.throwEx(122, "Corrupted message");
        }
        AQjmsOracleDebug.trace(4, "AQjmsUtil.getBytesData", "exit");
        return bytesData;
    }
}

