/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.sql.Connection;
import java.sql.SQLException;
import javax.jms.JMSException;
import javax.sql.XAConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jms.AQjmsDBConnMgr;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;

class AQjmsGeneralDBConnection {
    private static final String ORACLE_DRIVER_DEFAULT_URL = "jdbc:oracle:kprb:";
    private AQjmsDBConnMgr m_connMgr = null;
    private Connection m_dbConn = null;
    private XAConnection m_xaConn = null;
    private boolean m_isExternal;
    private boolean m_force;
    final String providerKey;

    AQjmsGeneralDBConnection(AQjmsDBConnMgr connMgr, Connection dbConn, boolean isExternal, boolean force) throws JMSException {
        this.m_connMgr = connMgr;
        this.m_dbConn = dbConn;
        this.m_isExternal = isExternal;
        this.m_force = force;
        this.providerKey = this.getProviderKey();
    }

    AQjmsGeneralDBConnection(AQjmsDBConnMgr connMgr, XAConnection xaConn, boolean isExternal, boolean force) throws JMSException {
        this.m_connMgr = connMgr;
        this.m_xaConn = xaConn;
        this.m_isExternal = isExternal;
        this.m_force = force;
        this.providerKey = this.getProviderKey();
    }

    Connection getDBConnection() throws JMSException {
        if (this.m_dbConn == null) {
            try {
                this.m_dbConn = this.m_xaConn.getConnection();
            }
            catch (SQLException sqe) {
                throw new AQjmsException(sqe);
            }
        }
        return this.m_dbConn;
    }

    private String getProviderKey() throws JMSException {
        try {
            String dbKey;
            OracleConnection internalConnection = (OracleConnection)this.m_dbConn;
            String url = internalConnection.getURL();
            int dbSpecifierStart = url.indexOf(64);
            if (dbSpecifierStart < 0) {
                if (!ORACLE_DRIVER_DEFAULT_URL.equals(url) && !"jdbc:default:connection:".equals(url)) {
                    AQjmsError.throwEx(112);
                }
                dbKey = ORACLE_DRIVER_DEFAULT_URL;
            } else {
                dbKey = url.substring(dbSpecifierStart);
            }
            return dbKey.toUpperCase();
        }
        catch (SQLException e) {
            throw new AQjmsException(e);
        }
    }

    XAConnection getXAConnection() {
        return this.m_xaConn;
    }

    boolean isExternal() {
        return this.m_isExternal;
    }

    void close() throws JMSException {
        Throwable closeException;
        block10: {
            closeException = null;
            if (this.m_isExternal) {
                AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "do not close external connection");
                if (!this.m_force) {
                    AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "external connection used with non-force flag, call connMgr's releaseExternalConnection");
                    this.m_connMgr.releaseExternalConnection();
                }
            } else {
                try {
                    if (this.m_dbConn != null) {
                        AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "close DB connection");
                        this.m_dbConn.close();
                    }
                }
                catch (Throwable t) {
                    AQjmsOracleDebug.traceEx(2, "AQjmsGeneralDBConnection.close: close db connection", t);
                    closeException = t;
                }
                try {
                    if (this.m_xaConn != null) {
                        AQjmsOracleDebug.trace(3, "AQjmsGeneralDBConnection.close", "close XA connection");
                        this.m_xaConn.close();
                    }
                }
                catch (Throwable t) {
                    AQjmsOracleDebug.traceEx(2, "AQjmsGeneralDBConnection.close: close db connection", t);
                    if (closeException != null) break block10;
                    closeException = t;
                }
            }
        }
        this.m_dbConn = null;
        this.m_xaConn = null;
        this.m_connMgr = null;
        if (closeException != null) {
            AQjmsError.throwEx("Error in close AQjmsGeneralDBConnection", closeException);
        }
    }
}

