/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsOracleDebug;

class AQjmsExceptionListener
extends Thread
implements ExceptionListener {
    public static final long DEFAULT_PING_PERIOD = 120000L;
    private static final String PING_QUERY = "SELECT banner FROM v$version where 1<>1";
    private PreparedStatement m_pstmt;
    private ExceptionListener m_el;
    private long m_period = 120000L;
    private boolean m_stop = false;
    private boolean m_suspended = true;
    private boolean m_registered = false;
    private Connection m_dbConn;
    private AQjmsGeneralDBConnection m_genConn;

    AQjmsExceptionListener(AQjmsGeneralDBConnection genConn) throws JMSException {
        this.m_genConn = genConn;
        this.m_dbConn = genConn.getDBConnection();
        try {
            this.m_pstmt = this.m_dbConn.prepareStatement(PING_QUERY);
            this.m_pstmt.setQueryTimeout(1);
        }
        catch (SQLException sqlEx) {
            AQjmsOracleDebug.traceEx(3, "AQjmsExceptionListener constructor", sqlEx);
            throw new AQjmsException(sqlEx);
        }
    }

    synchronized void setExceptionListener(ExceptionListener el) {
        if (el == null) {
            this.m_registered = false;
        } else {
            this.m_registered = true;
            if (!this.isAlive()) {
                this.start();
            }
        }
        this.m_el = el;
    }

    ExceptionListener getExceptionListener() {
        return this.m_el;
    }

    public synchronized void onException(JMSException jmsEx) {
        if (this.m_el != null) {
            try {
                this.m_el.onException(jmsEx);
            }
            catch (RuntimeException rte) {
                AQjmsOracleDebug.traceEx(2, "Exception thrown by onException()", rte);
                throw rte;
            }
            catch (Error err) {
                AQjmsOracleDebug.traceErr(2, "Error thrown by onException()", err);
                throw err;
            }
        }
    }

    void setPingPeriod(long period) {
        if (period <= 0L) {
            return;
        }
        this.m_period = period;
    }

    long getPingPeriod() {
        return this.m_period;
    }

    public void run() {
        boolean i = false;
        while (!this.m_stop) {
            try {
                AQjmsExceptionListener.sleep(this.m_period);
                if (!this.m_registered || this.m_suspended) continue;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "executing query");
                this.m_pstmt.executeQuery();
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "done executing query");
            }
            catch (InterruptedException intEx) {
                if (!this.m_stop) continue;
                AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "run stopped");
                return;
            }
            catch (SQLException sqlEx) {
                JMSException jmsEx = new JMSException(sqlEx.toString());
                this.onException(jmsEx);
                this.m_stop = true;
            }
        }
    }

    synchronized void resumeExceptionListener() {
        if (this.m_suspended) {
            this.m_suspended = false;
        }
    }

    synchronized void suspendExceptionListener() {
        this.m_suspended = true;
    }

    void close() {
        try {
            if (!this.m_stop) {
                this.m_stop = true;
                if (this.isAlive()) {
                    final AQjmsExceptionListener expThread = this;
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            expThread.interrupt();
                            return null;
                        }
                    });
                    try {
                        this.join(500L);
                    }
                    catch (InterruptedException intExp) {
                        AQjmsOracleDebug.trace(5, "AQjmsExceptionListener", "in close, InterruptedException caught");
                    }
                }
            }
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.close();
                }
                catch (SQLException sqlEx) {
                    // empty catch block
                }
                this.m_pstmt = null;
            }
            try {
                this.m_genConn.close();
            }
            catch (JMSException sqlEx) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

