/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsTopicConnectionFactory;
import oracle.jms.AQjmsUtil;
import oracle.jms.AQjmsXAConnectionFactory;
import oracle.jms.AQjmsXAQueueConnectionFactory;
import oracle.jms.AQjmsXATopicConnectionFactory;
import oracle.jms.WebLogicHelper;

public class AQjmsConnectionFactory
implements ObjectFactory,
ConnectionFactory,
Serializable {
    String hostname;
    String oracle_sid;
    int portno;
    String jdbc_driver;
    String jdbc_conn_str;
    String user;
    String passwd;
    String classname;
    Properties jdbc_info;
    DataSource data_source;
    boolean compliant = AQjmsConstants.IS_COMPLIANT;
    static final String HOST_ATTR = "host";
    static final String PORT_ATTR = "port";
    static final String SID_ATTR = "sid";
    static final String JDBC_CNN_ATTR = "jdbc_connect_string";
    static final String JDBC_DRV_ATTR = "driver";
    static final String USER_NAM_ATTR = "username";
    static final String PASSWORD_ATTR = "password";

    AQjmsConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        this.hostname = hostname;
        this.oracle_sid = oracle_sid;
        this.portno = portno;
        this.data_source = null;
        if (driver != null) {
            if (driver.equalsIgnoreCase("thin")) {
                this.jdbc_driver = "thin";
            } else if (driver.equalsIgnoreCase("oci8")) {
                this.jdbc_driver = "oci8";
            } else if (driver.equalsIgnoreCase("oci")) {
                this.jdbc_driver = "oci";
            } else {
                AQjmsError.throwEx(135, driver);
            }
        } else {
            this.jdbc_driver = "thin";
        }
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "hostname: " + hostname + "  oracle_sid: " + oracle_sid + "  port_no: " + portno + "  driver: " + driver);
    }

    AQjmsConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = null;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "with jdbc connect string");
    }

    AQjmsConnectionFactory(DataSource dsobj) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = dsobj;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "data source object: " + dsobj);
    }

    AQjmsConnectionFactory(DataSource dsobj, String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.data_source = dsobj;
        this.jdbc_conn_str = jdbc_connect_str;
        this.jdbc_info = jdbc_props;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "with both ds and jdbc connect string");
    }

    AQjmsConnectionFactory(String dsname) throws JMSException {
        this.hostname = null;
        this.oracle_sid = null;
        this.portno = 0;
        this.jdbc_driver = null;
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.data_source = (DataSource)AQjmsUtil.lookupObject(dsname, DataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory - constructor", "data source name: " + dsname);
    }

    public AQjmsConnectionFactory() {
        this.jdbc_driver = "thin";
        this.jdbc_conn_str = null;
        this.jdbc_info = null;
        this.user = null;
        this.passwd = null;
        this.classname = null;
    }

    public void setJdbcURL(String jdbcURL) throws JMSException {
        this.jdbc_conn_str = jdbcURL;
    }

    public String getJdbcURL() {
        return this.jdbc_conn_str;
    }

    public void setUsername(String user) throws JMSException {
        if (this.jdbc_info == null) {
            this.jdbc_info = new Properties();
        }
        this.jdbc_info.put("user", user);
    }

    public String getUsername() {
        if (this.jdbc_info == null) {
            return null;
        }
        String user = (String)this.jdbc_info.get("user");
        return user;
    }

    public void setPassword(String password) throws JMSException {
        if (this.jdbc_info == null) {
            this.jdbc_info = new Properties();
        }
        this.jdbc_info.put(PASSWORD_ATTR, password);
    }

    public void setDatasource(DataSource dataSource) throws JMSException {
        this.data_source = dataSource;
    }

    public DataSource getDataSource() {
        return this.data_source;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws JMSException {
        Reference ref = (Reference)obj;
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "entry");
        if (ref == null) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        this.classname = ref.getClassName();
        if (!(this.classname.equals("oracle.jms.AQjmsQueueConnectionFactory") || this.classname.equals("oracle.jms.AQjmsTopicConnectionFactory") || this.classname.equals("oracle.jms.AQjmsConnectionFactory") || this.classname.equals("oracle.jms.AQjmsXAQueueConnectionFactory") || this.classname.equals("oracle.jms.AQjmsXATopicConnectionFactory") || this.classname.equals("oracle.jms.AQjmsXAConnectionFactory"))) {
            AQjmsOracleDebug.trace(3, "AQjmsConnectionFactory.getObjectInstance", "unable to manufacture object of class: " + this.classname);
            return null;
        }
        AQjmsConnectionFactory factObj = null;
        try {
            SearchControls constraints = new SearchControls();
            String[] attrstoret = new String[]{"orclDBAQGeneric"};
            constraints.setSearchScope(0);
            constraints.setReturningAttributes(attrstoret);
            DirContext ctx = (DirContext)nameCtx;
            NamingEnumeration<SearchResult> results = ctx.search(name, "(objectclass=*)", constraints);
            if (results != null) {
                SearchResult si = results.next();
                Attribute attr = si.getAttributes().get("orclDBAQGeneric");
                for (int i = 0; i < attr.size(); ++i) {
                    String val = (String)attr.get(i);
                    if (val.toLowerCase().startsWith(HOST_ATTR)) {
                        this.hostname = val.substring(HOST_ATTR.length() + 1);
                        continue;
                    }
                    if (val.toLowerCase().startsWith(PORT_ATTR)) {
                        this.portno = Integer.valueOf(val.substring(PORT_ATTR.length() + 1));
                        continue;
                    }
                    if (val.toLowerCase().startsWith(SID_ATTR)) {
                        this.oracle_sid = val.substring(SID_ATTR.length() + 1);
                        continue;
                    }
                    if (val.toLowerCase().startsWith(JDBC_CNN_ATTR)) {
                        this.jdbc_conn_str = val.substring(JDBC_CNN_ATTR.length() + 1);
                        continue;
                    }
                    if (val.toLowerCase().startsWith(JDBC_DRV_ATTR)) {
                        this.jdbc_driver = val.substring(JDBC_DRV_ATTR.length() + 1);
                        continue;
                    }
                    if (val.toLowerCase().startsWith(USER_NAM_ATTR)) {
                        this.user = val.substring(USER_NAM_ATTR.length() + 1);
                        continue;
                    }
                    if (!val.toLowerCase().startsWith(PASSWORD_ATTR)) continue;
                    this.passwd = val.substring(PASSWORD_ATTR.length() + 1);
                }
                if (this.user != null && this.passwd != null) {
                    this.jdbc_info = new Properties();
                    this.jdbc_info.put("user", this.user);
                    this.jdbc_info.put(PASSWORD_ATTR, this.passwd);
                }
                if (this.classname.equals("oracle.jms.AQjmsQueueConnectionFactory")) {
                    factObj = this.jdbc_conn_str != null ? new AQjmsQueueConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsQueueConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsTopicConnectionFactory")) {
                    factObj = this.jdbc_conn_str != null ? new AQjmsTopicConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsTopicConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsConnectionFactory")) {
                    factObj = this.jdbc_conn_str != null ? new AQjmsConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsXAQueueConnectionFactory")) {
                    factObj = this.jdbc_conn_str != null ? new AQjmsXAQueueConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsXAQueueConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsXATopicConnectionFactory")) {
                    factObj = this.jdbc_conn_str != null ? new AQjmsXATopicConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsXATopicConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                } else if (this.classname.equals("oracle.jms.AQjmsXAConnectionFactory")) {
                    factObj = this.jdbc_conn_str != null ? new AQjmsXAConnectionFactory(this.jdbc_conn_str, this.jdbc_info) : new AQjmsXAConnectionFactory(this.hostname, this.oracle_sid, this.portno, this.jdbc_driver);
                }
            }
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsConnectionFactory.getObjectInstance", e);
            AQjmsError.throwEx(205, (Throwable)e);
        }
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.getObjectInstance", "exit");
        return factObj;
    }

    public Connection createConnection() throws JMSException {
        AQjmsConnection conn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            conn = new AQjmsConnection(this.data_source, null, null, 30);
        } else {
            conn = this.jdbc_conn_str != null ? new AQjmsConnection(this.jdbc_conn_str, this.jdbc_info, 30) : (this.data_source != null ? new AQjmsConnection(this.data_source, null, null, 30) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 30));
        }
        conn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmConnectionFactory.createConnection", "Connection created successfully");
        return conn;
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        AQjmsConnection conn = null;
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory.createConnection", "with user/pwd");
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            conn = new AQjmsConnection(this.data_source, userName, password, 30);
        } else {
            Properties new_info = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (userName != null || password != null) {
                        new_info = (Properties)this.jdbc_info.clone();
                        new_info.put("user", userName);
                        new_info.put(PASSWORD_ATTR, password);
                    } else {
                        new_info = this.jdbc_info;
                    }
                    conn = new AQjmsConnection(this.jdbc_conn_str, new_info, 30);
                } else {
                    conn = new AQjmsConnection(this.jdbc_conn_str, userName, password, 30);
                }
            } else {
                conn = this.data_source != null ? new AQjmsConnection(this.data_source, userName, password, 30) : new AQjmsConnection(this.hostname, this.oracle_sid, this.portno, userName, password, this.jdbc_driver, 30);
            }
        }
        conn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsConnectionFactory.createConnection w/username/password", "Connection created successfully");
        return conn;
    }

    boolean getCompliant() {
        return this.compliant;
    }

    void setCompliant(boolean compliant) {
        this.compliant = compliant;
        AQjmsOracleDebug.trace(4, "AQjmsConnectionFactory.setCompliant", "Current <compliant> is set to:" + compliant);
    }
}

