/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetGB18030
extends CharacterSetWithConverter {
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    CharacterSetGB18030(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSetGB18030 getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 9) {
            return new CharacterSetGB18030(n2, jdbcCharacterConverters);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        if (n2 <= 127) return n2;
        if (characterWalker.bytes.length <= characterWalker.next + 1) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if ((characterWalker.bytes[characterWalker.next] & 0xFF) >= 129 && (characterWalker.bytes[characterWalker.next] & 0xFF) <= 254 && (characterWalker.bytes[characterWalker.next + 1] & 0xFF) >= 48 && (characterWalker.bytes[characterWalker.next + 1] & 0xFF) <= 57) {
            if (characterWalker.bytes.length <= characterWalker.next + 3) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if ((characterWalker.bytes[characterWalker.next + 2] & 0xFF) >= 129 && (characterWalker.bytes[characterWalker.next + 2] & 0xFF) <= 254 && (characterWalker.bytes[characterWalker.next + 3] & 0xFF) >= 48 && (characterWalker.bytes[characterWalker.next + 3] & 0xFF) <= 57) {
                n2 = (characterWalker.bytes[characterWalker.next] & 0xFF) << 24 | (characterWalker.bytes[characterWalker.next + 1] & 0xFF) << 16 | (characterWalker.bytes[characterWalker.next + 2] & 0xFF) << 8 | characterWalker.bytes[characterWalker.next + 3] & 0xFF;
                characterWalker.next += 4;
                return n2;
            }
            n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
            ++characterWalker.next;
            return n2;
        }
        n2 = (characterWalker.bytes[characterWalker.next] & 0xFF) << 8 | characterWalker.bytes[characterWalker.next + 1] & 0xFF;
        characterWalker.next += 2;
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        while (n2 >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        if (n2 >> 16 != 0) {
            n3 = 3;
            n4 = 4;
        } else if (n2 >> 8 != 0) {
            n3 = 1;
            n4 = 2;
        } else {
            n3 = 0;
            n4 = 1;
        }
        CharacterSetGB18030.need(characterBuffer, n4);
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

