/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import oracle.AQ.AQConstants;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQEnqueueOptions;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsUtil;
import oracle.jms.WebLogicHelper;

public class AQjmsConstants
extends AQConstants {
    static final int JDBC_OCI8 = 1;
    static final int JDBC_THIN = 2;
    static final int DEFAULT_JDBC_DRIVER = 2;
    static final int QUEUE = 10;
    static final int TOPIC = 20;
    static final int UNIFIED = 30;
    static final int PERSISTENT = 2;
    static final int NON_PERSISTENT = 1;
    static final int AQ_IN_MEMORY = 2;
    static final int AQ_PERSISTENT = 1;
    static final int AQ_PERSISTENT_OR_IN_MEMORY = 3;
    static final int DEFAULT_PRIORITY = 1;
    static final int MIN_JMS_PRIORITY = 0;
    static final int MAX_JMS_PRIORITY = 9;
    static final int STRING_PROPERTY = 100;
    static final int NUMBER_PROPERTY = 200;
    static final int BOOLEAN = 20;
    static final int BYTE = 21;
    static final int SHORT = 22;
    static final int INT = 23;
    static final int LONG = 24;
    static final int FLOAT = 25;
    static final int DOUBLE = 26;
    static final int STRING = 27;
    static final int CHAR = 28;
    static final int BYTE_ARRAY = 29;
    static final int DEVIATION_BEFORE = 2;
    static final int DEVIATION_TOP = 3;
    static final int READONLY = 0;
    static final int WRITEONLY = 1;
    static final int READWRITE = 2;
    static final int SUBS_RULE = 10;
    static final int SEL_CORRID = 20;
    static final int SEL_MSGID = 30;
    static final int ADT_RULE = 40;
    static final int SEL_DEQCND = 50;
    static final int BYTES_MESSAGE = 10;
    static final int STREAM_MESSAGE = 20;
    public static final int NORMAL = 0;
    public static final int EXCEPTION = 1;
    public static final int WAIT_FOREVER = -1;
    public static final int WAIT_NONE = 0;
    static final String DEFAULT_JDBC_DRIVER_STR = "thin";
    static final int MAX_HEADER_PROP_SIZE = 100;
    static final int MAX_PROP_NAME_SIZE = 100;
    static final int MAX_PROP_STR_VAL = 2000;
    static final int MAX_PROPERTIES = 1000;
    static final int MAX_RAW_SIZE = 2000;
    static final int MAX_VARCHAR_SIZE = 4000;
    static final int MAX_RULE_SIZE = 4000;
    private static final int DEFAULT_CLOSE_CHECK_INTERVAL = 120;
    private static int closeCheckInterval = -1;
    static final int MIN_CLOSE_CHK_INTERVAL = 1;
    public static final int NONE = 0;
    public static final int TRANSACTIONAL = 1;
    static final int MAX_QUEUE_NAME = 30;
    static final int MAX_FULL_QUEUE_NAME = 61;
    static final int MAX_CONSUMER_NAME = 30;
    static final int MAX_SUBSCRIPTION_NAME = 92;
    static final int MAX_ADDRESS = 128;
    static final int MSGID_LEN = 16;
    static final int MAX_CORRELATION_LEN = 128;
    static final int MAX_NOTIFIER_CONN = 1024;
    static final int DEFAULT_CPOOL_CACHE_SIZE = 50;
    static final int DEFAULT_CPOOL_MIN_LIMIT = 1;
    static final int DEFAULT_CPOOL_INCREMENT = 1;
    public static final String INIT_CTX_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    public static final String SERVER_DN = "server_dn";
    public static final String LDAP_GEN_ATTR = "orclDBAQGeneric";
    public static final String LDAP_OWN_ATTR = "orclDBAQObjOwner";
    public static final String LDAP_NAM_ATTR = "orclDBAQObjName";
    public static final String LDAP_TYP_ATTR = "orclDBAQObjType";
    public static final String LDAP_PTR_ATTR = "orclDBAQPointerAttr";
    public static final String LDAP_CN_ATTR = "cn";
    public static final String LDAP_QUEUE_DIR = "oracledbqueues";
    public static final String LDAP_QUTAB_DIR = "oracledbqueuetables";
    public static final String LDAP_AGENT_DIR = "oracledbagents";
    public static final String LDAP_CONN_DIR = "oracledbconnections";
    public static final String LDAP_JMSSB_DIR = "oracledbjmssubscribers";
    static final int PRESENTATION_RAW = 1;
    static final int VERSION_8_1_6_0_0 = 1;
    static final int INT_LENGTH = 4;
    static final int AQ_SOCKET_ACCEPT_TIMEOUT = 120000;
    static final int DESTPLOAD_JMSTYPE = 1;
    static final int DESTPLOAD_USERADT = 2;
    static final int DESTPLOAD_ANYDATA = 3;
    static final int JMS_TEXT_MESSAGE = 0;
    static final int JMS_BYTES_MESSAGE = 1;
    static final int JMS_STREAM_MESSAGE = 2;
    static final int JMS_MAP_MESSAGE = 3;
    static final int JMS_OBJECT_MESSAGE = 4;
    static final int NOT_GENERAL_PAYLOAD = 0;
    static final int IS_GENERAL_PAYLOAD = 1;
    private static final boolean DEFAULT_SYNC_DEBUG = false;
    static final boolean SYNC_DEBUG = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.syncDebug", "false"));
    private static final boolean DEFAULT_COMPLIANCE = WebLogicHelper.runningInWLServer();
    static final boolean IS_COMPLIANT = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.j2eeCompliant", "" + DEFAULT_COMPLIANCE));
    private static final boolean DEFAULT_USE_JDBC_AQ = true;
    static final boolean USE_JDBC_AQ = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.useJdbcAQ", "true"));
    private static final boolean DEFAULT_IGNORE_PRIORITY = false;
    static final boolean IGNORE_PRIORITY = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.ignorePriority", "false"));
    private static final boolean DEFAULT_ORDER_WITH_SELECTOR = true;
    static final boolean ORDER_WITH_SELECTOR = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.orderWithSelector", "true"));
    private static final boolean DEFAULT_USETEMPLOBS = false;
    static final boolean IS_USETEMPLOBS = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.useTemplobsForEnqueue", "false"));
    private static final boolean DEFAULT_SELTYPES = WebLogicHelper.runningInWLServer();
    private static final boolean IS_STRONG_SELECTOR_TYPES = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.stronglyTypedSelectors", "" + DEFAULT_SELTYPES));
    private static final boolean DEFAULT_OCI_NATIVE_PATH = true;
    public static final boolean OCI_NATIVE_PATH = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.ociNativePath", "true"));
    private static final boolean DEFAULT_PRINT_LINKED_EXCEPTION = true;
    public static final boolean PRINT_LINKED_EXCEPTION = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.printLinkedException", "true"));
    private static final long DEFAULT_LONG_LOB_THRESHOLD = 0x6400000L;
    private static long s_longLobThreshold = -1L;
    private static final boolean DEFAULT_CACHE_DS_IN_CONTEXT = true;
    public static final boolean CACHE_DS_IN_CONTEXT = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.cacheDSInContext", "true"));
    private static final boolean DEFAULT_USE_EMULATED_XA = true;
    public static final boolean USE_EMULATED_XA = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.useEmulatedXA", "true"));
    private static final boolean DEFAULT_USE_AQ_NONDURABLE_SUBSCRIBER = false;
    static final boolean USE_AQ_NONDURABLE_SUBSCRIBER = Boolean.valueOf(AQjmsUtil.getSystemProperty("oracle.jms.useAQNondurableSubscriber", "false"));
    public static final int SYSTEM_EXCEPTION = 1;
    public static final int LISTENER_EXCEPTION = 2;
    public static final int SIMPLE_SCHEDULER = 1;
    public static final int STATISTICS_SCHEDULER = 2;
    public static final long DEFAULT_MIN_SLEEP_TIME = 1000L;
    public static final long DEFAULT_MAX_SLEEP_TIME = 15000L;
    public static final long DEFAULT_LISTENER_RETRY = 1000L;
    private static long minSleepTime = -1L;
    private static long maxSleepTime = -1L;
    private static long listenerRetry = -1L;
    private static int defaultScheduler = -1;
    private static int navigationMode = -1;

    public static synchronized long getLongLobThreshold() {
        if (s_longLobThreshold == -1L) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.longLobThreshold");
            if (strVal != null) {
                try {
                    s_longLobThreshold = Long.parseLong(strVal);
                }
                catch (NumberFormatException nfe) {
                    s_longLobThreshold = 0x6400000L;
                }
            } else {
                s_longLobThreshold = 0x6400000L;
            }
        }
        return s_longLobThreshold;
    }

    public static boolean useEmulatedXA() {
        return USE_EMULATED_XA;
    }

    public static boolean printLinkedException() {
        return PRINT_LINKED_EXCEPTION;
    }

    public static boolean useJdbcAQ() {
        return USE_JDBC_AQ;
    }

    public static boolean useAQNondurableSubscriber() {
        return USE_AQ_NONDURABLE_SUBSCRIBER;
    }

    public static boolean ignorePriority() {
        return IGNORE_PRIORITY;
    }

    public static boolean isStronglyTypedSelector() {
        return IS_STRONG_SELECTOR_TYPES;
    }

    public static synchronized boolean syncDebug() {
        return SYNC_DEBUG;
    }

    public static synchronized int getDefaultScheduler() {
        if (defaultScheduler == -1) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.defaultScheduler");
            defaultScheduler = strVal != null && strVal.equalsIgnoreCase("STAT") ? 2 : 1;
        }
        return defaultScheduler;
    }

    public static synchronized long getMinSleepTime() {
        if (minSleepTime == -1L) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.minSleepTime");
            if (strVal != null) {
                try {
                    minSleepTime = Long.parseLong(strVal);
                }
                catch (NumberFormatException nfe) {
                    minSleepTime = 1000L;
                }
            } else {
                minSleepTime = 1000L;
            }
        }
        return minSleepTime;
    }

    public static synchronized long getMaxSleepTime() {
        if (maxSleepTime == -1L) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.maxSleepTime");
            if (strVal != null) {
                try {
                    maxSleepTime = Long.parseLong(strVal);
                }
                catch (NumberFormatException nfe) {
                    maxSleepTime = 15000L;
                }
            } else {
                maxSleepTime = 15000L;
            }
        }
        return maxSleepTime;
    }

    public static synchronized long getListenerRetry() {
        if (listenerRetry == -1L) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.listenerRetry");
            if (strVal != null) {
                try {
                    listenerRetry = Long.parseLong(strVal);
                }
                catch (NumberFormatException nfe) {
                    listenerRetry = 1000L;
                }
            } else {
                listenerRetry = 1000L;
            }
        }
        return listenerRetry;
    }

    public static synchronized int getCloseCheckInterval() {
        if (closeCheckInterval == -1) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.closeCheckInterval");
            if (strVal != null) {
                try {
                    closeCheckInterval = Integer.parseInt(strVal);
                }
                catch (NumberFormatException nfe) {
                    closeCheckInterval = 120;
                }
            } else {
                closeCheckInterval = 120;
            }
        }
        return closeCheckInterval;
    }

    public static synchronized int getNavigationMode() {
        if (navigationMode == -1) {
            String strVal = AQjmsUtil.getSystemProperty("oracle.jms.conservativeNavigation");
            navigationMode = strVal != null && Boolean.parseBoolean(strVal) ? 1 : 3;
        }
        return navigationMode;
    }

    static AQDequeueOptions.DequeueMode toDequeueModeEnum(int dequeueMode) throws JMSException {
        switch (dequeueMode) {
            case 1: {
                return AQDequeueOptions.DequeueMode.BROWSE;
            }
            case 2: {
                return AQDequeueOptions.DequeueMode.LOCKED;
            }
            case 3: {
                return AQDequeueOptions.DequeueMode.REMOVE;
            }
            case 4: {
                return AQDequeueOptions.DequeueMode.REMOVE_NODATA;
            }
        }
        AQjmsError.throwEx(124);
        return AQDequeueOptions.DequeueMode.REMOVE;
    }

    static AQDequeueOptions.NavigationOption toNavigationEnum(int navigationMode) throws JMSException {
        switch (navigationMode) {
            case 1: {
                return AQDequeueOptions.NavigationOption.FIRST_MESSAGE;
            }
            case 2: {
                return AQDequeueOptions.NavigationOption.NEXT_TRANSACTION;
            }
            case 3: {
                return AQDequeueOptions.NavigationOption.NEXT_MESSAGE;
            }
        }
        AQjmsError.throwEx(128);
        return AQDequeueOptions.NavigationOption.NEXT_MESSAGE;
    }

    static AQDequeueOptions.VisibilityOption toDequeueVisibilityEnum(int visibility) throws JMSException {
        switch (visibility) {
            case 1: {
                return AQDequeueOptions.VisibilityOption.IMMEDIATE;
            }
            case 2: {
                return AQDequeueOptions.VisibilityOption.ON_COMMIT;
            }
        }
        AQjmsError.throwEx(192);
        return AQDequeueOptions.VisibilityOption.ON_COMMIT;
    }

    static AQDequeueOptions.DeliveryFilter toDeliveryFilterEnum(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 1: {
                return AQDequeueOptions.DeliveryFilter.PERSISTENT;
            }
            case 2: {
                return AQDequeueOptions.DeliveryFilter.BUFFERED;
            }
            case 3: {
                return AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED;
            }
        }
        AQjmsError.throwEx(122, "Invalid AQ delivery mode");
        return AQDequeueOptions.DeliveryFilter.PERSISTENT;
    }

    static AQEnqueueOptions.VisibilityOption toEnqueueVisibilityEnum(int visibility) throws JMSException {
        switch (visibility) {
            case 1: {
                return AQEnqueueOptions.VisibilityOption.IMMEDIATE;
            }
            case 2: {
                return AQEnqueueOptions.VisibilityOption.ON_COMMIT;
            }
        }
        AQjmsError.throwEx(192);
        return AQEnqueueOptions.VisibilityOption.ON_COMMIT;
    }

    static AQEnqueueOptions.DeliveryMode toEnqueueDeliveryModeEnum(int deliveryMode) throws JMSException {
        switch (deliveryMode) {
            case 1: {
                return AQEnqueueOptions.DeliveryMode.PERSISTENT;
            }
            case 2: {
                return AQEnqueueOptions.DeliveryMode.BUFFERED;
            }
        }
        AQjmsError.throwEx(122, "Invalid AQ delivery mode");
        return AQEnqueueOptions.DeliveryMode.PERSISTENT;
    }

    static AQEnqueueOptions.SequenceDeviationOption toSequenceDeviationEnum(int sd) throws JMSException {
        switch (sd) {
            case 2: {
                return AQEnqueueOptions.SequenceDeviationOption.BEFORE;
            }
            case 3: {
                return AQEnqueueOptions.SequenceDeviationOption.TOP;
            }
        }
        AQjmsError.throwEx(154);
        return AQEnqueueOptions.SequenceDeviationOption.TOP;
    }
}

