package com.hzjt.service;

import com.google.gson.Gson;
import com.hzjt.domain.Storageserver;
import com.hzjt.mapper.StorageServerMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class CacheLoadService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Value("${spring.redis.cachekey.ftplist}")
    private String ftplistkey;

    @Autowired
    private StorageServerMapper storageServerMapper;

    public boolean loadFtpCache() {
        try {
            Storageserver server = new Storageserver();
            server.setServerstatus(0);//õ
            server.setServertype("ftp");
            List<Storageserver> storageServers = storageServerMapper.queryStorageServerAll(server);
            if (!storageServers.isEmpty() && storageServers.size() > 0) {
                stringRedisTemplate.opsForValue().set(ftplistkey, new Gson().toJson(storageServers));
            } else {
                System.out.println("storageServers.isEmpty");
            }
            return true;
        } catch (Exception e) {
            System.out.println(e.toString());
            log.error(e.getMessage());
            return false;
        }
    }

}
