package com.hzjt.controller;

import cn.hutool.core.codec.Base64Encoder;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.RateLimiter;
import com.hzjt.domain.*;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.handler.WebSocket;
import com.hzjt.mapper.SbtdspsrMapper;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.redis.RedisDao;
import com.hzjt.service.*;
import com.hzjt.util.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.bind.annotation.*;

import javax.websocket.server.PathParam;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;


@RestController
@Slf4j
public class TraffController {
    @Autowired
    ImportService importService;

    @Autowired
    WebSocket webSocket;

    private Map<String, RateLimiter> rateLimiterMap;
    private String port;
    private String dept;
    private Integer rate = 10;
    private SbtdspsrMapper sbtdspsrMapper;

    @Autowired
    TraffFlowService traffFlowService;

    @Value("${flv.resisvalue}")
    private String resisvalue;

    @Value("${json.resisurl}")
    private String resisjsonvalue;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    RedisDao redisDao;

    @Autowired
    private TraffAlarmRecordMapper traffAlarmRecordMapper;

    @Autowired
    FtpService ftpService;

    @Autowired
    EventWriteService eventWriteService;
    @Value("ftpIp")
    String ftpIp;
    @Value("ftpPort")
    private String ftpPort;
    @Value("ftpUsername")
    private String ftpUsername;
    @Value("ftpPassword")
    private String ftpPassword;
    @Value("${alarmrecord.check.enable}")
    private String checkEnable;

    Long ldir = new Long(180);
    @Autowired
    FLVCacheService flvCacheService;

//    @Autowired
//    private SimpMessagingTemplate template;


    private static final String TYPE = "TRAFFIC_INCIDENT_ALARM";

    ScheduledExecutorService schedulepool = Executors.newScheduledThreadPool(5); //创

    @Autowired
    public TraffController(
            @Value("${port}") String port,
            @Value("${message.dept}") String dept,
            @Value("${message.rate}") Integer rate, SbtdspsrMapper sbtdspsrMapper) {

        this.port = port;
        this.rate = rate;
        this.dept = dept.substring(0, 5);
        this.sbtdspsrMapper = sbtdspsrMapper;
        rateLimiterMap = new ConcurrentHashMap<>(16);
    }

    @PostMapping("/alarmevent")
    public ResultObj rece(@RequestBody Alarm trffClientMessage) {
        WebSocket.GroupSending(JsonUtil.beanToString(trffClientMessage));
//    log.info("alarmevent--------------"+trffClientMessage.toString());
        if (!TYPE.equals(trffClientMessage.getType())) {
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "type类型不正确");
        }


        if (trffClientMessage.getImg_urls().isEmpty()) {
            return ResultObj.error(ResponseEnum.E_1004.getCode(), "img_urls值不能为空");
        }
        if (StringUtils.isBlank(trffClientMessage.getIncident_type())) {
            log.info("incident_type值不能为空" + trffClientMessage.toString());
            return ResultObj.error(ResponseEnum.E_1004.getCode(), "incident_type值不能为空");
        }
        String videoId = trffClientMessage.getVideo_id();

        if (StringUtils.isBlank(videoId)) {
            log.info("video_id值异常 值为:" + videoId);
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "video_id值异常 值为:" + videoId);
        }
        /* 限流 */
        if (!getRateLimiter(videoId).tryAcquire()) {
            log.info("[事件推送]->设备" + videoId + "-推送已达到限流限制");
            return ResultObj.error(ResponseEnum.E_9999.getCode(), "设备" + videoId + "请求过于频繁");
        }
        String sbbh="";
        int tdbh=0;
        if( videoId.contains("_") && videoId.split("_").length == 2) {
            String[] sbAndTd = videoId.split("_");
            sbbh = sbAndTd[0];
            tdbh = Integer.valueOf(sbAndTd[1]) + 1;
        }
        else {
            sbbh=videoId;
            //重新赋值videoid
            trffClientMessage.setVideo_id(videoId+"_0");
        }
        List<Sbtdspsr> sbtdspsrs = sbtdspsrMapper.selectBySbbh(sbbh, tdbh);
        if (sbtdspsrs.isEmpty()) {
            log.info("设备为:" + sbbh + ",通道为:" + tdbh + "未录入(备案)");
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "设备为:" + sbbh + ",通道为:" + tdbh + "未录入(备案)");
        }
        String xzbh = sbtdspsrs.get(0).getXzbh();
        if (xzbh.length() != 12) {
            log.info("设备为:" + sbbh + ",通道为:" + tdbh + "配置的行政区划" + xzbh + "不合规");
            return ResultObj.error(ResponseEnum.E_1002.getCode(), "设备为:" + sbbh + ",通道为:" + tdbh + "配置的行政区划不合规");
        }
        //ts  時間轉成正常時間
        trffClientMessage.setDept(xzbh);

        try { // 清空redis中的部分旧数据
//            importService.cleanCache();
            // 将参数result中的部分数据存入redis中，并把格式校验成功的数据发布至对应频道中
//            importService.cacheAndPublish(JsonUtil.beanToString(trffClientMessage));
            sendevent(trffClientMessage);
        } catch (Exception e) {
            log.error("MessageController receive putData error：" + e.toString());
        }
        return ResultObj.ok(trffClientMessage);
    }

    public void sendevent(Alarm trffClientMessage) {
        Traffalarmrecord traffAlarmRecord = new Traffalarmrecord();
        traffAlarmRecord.setAreaid(Long.valueOf(trffClientMessage.getDept()));
        traffAlarmRecord.setRecordtype(trffClientMessage.getIncident_type().toLowerCase());
        traffAlarmRecord.setRecordtime(new Date(Long.valueOf(trffClientMessage.getTs())));
        Integer channelid=Integer.valueOf(0);
        if(trffClientMessage.getVideo_id().contains("_")&& trffClientMessage.getVideo_id().split("_").length == 2) {
            String[] videoIdArr = trffClientMessage.getVideo_id().split("_");
            traffAlarmRecord.setFdid(videoIdArr[0]);
            channelid = Integer.valueOf(videoIdArr[1]) + 1;
        }
        else{
            traffAlarmRecord.setFdid(trffClientMessage.getVideo_id().replace("_0",""));

        }
        traffAlarmRecord.setChannelid(channelid);

        //判断是否在正检时间内
        int exists = traffAlarmRecordMapper.selectInChecktimeTraffAlarm(traffAlarmRecord);

//        log.info("selectInChecktimeTraffAlarm" + exists);
        if (exists > 0) {
            return;
        }

        traffAlarmRecord.setVideourlfrom(trffClientMessage.getVideo_record_url());
        traffAlarmRecord.setCreatetime(new Date());
        traffAlarmRecord.setObjlable(trffClientMessage.getObjLabel());
        traffAlarmRecord.setPushstatus(9);//设置为未推送

//        log.info("selectInworkRectifytimeTraffAlarm" + exists);
        if ((traffAlarmRecord.getRecordtype().equalsIgnoreCase("roadworks_out_of_line") || traffAlarmRecord.getRecordtype().equalsIgnoreCase("roadworks"))) {

            //支持对某一个点位报施工事件后 倒推RECTIFYTIME 查看是否是施工事件 一段时间（时间可以配置）之前的停车事件和行人闯入事件矫正为施工事件
            exists = traffAlarmRecordMapper.updateInworkRectifytimeTraffAlarm(traffAlarmRecord);
            //这个事件如果为停车事件或者行人闯入事件时，设置纠偏状态为1
            if (exists > 0) {
                log.info("setRectificationtype=1");
            }

        }

        List<String> imgBase64List = trffClientMessage.getImg_base64();
        String imgEnumHead = "IMG";
        Ftp ftp = ftpService.reloadFtp();
        for (int i = 0; i < imgBase64List.size(); i++) {
            /* 图片上传 */
            String path = trffClientMessage.getVideo_id() + "/" + DateUtils.formatCurrDayNoSign();
            String fileName = UUIDUtils.createuuid() + ".jpg";
            if (FTPUtil.uploadFile(ftp, path, fileName, imgBase64List.get(i))) {
                TraffAlarmRecordImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, FTPUtil.getFtpUrl(ftp) + path + "/" + fileName);
            }
        }
        List<String> imgUrls = trffClientMessage.getImg_urls();
        for (int i = 0; i < imgUrls.size(); i++) {
            TraffAlarmRecordFromImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, imgUrls.get(i));
        }

        if (StringEnum.ONE.getValue().equals(checkEnable)) {
            /* 9:免审 */
            traffAlarmRecord.setCheckstatus(9);
        }

        int recordid = traffAlarmRecordMapper.selectmax();
        traffAlarmRecord.setRecordid((long) (recordid));
        //发送给前端
        Map map = new HashMap();
        //判断是否需要手动筛选

        String  manualStatus=traffAlarmRecordMapper.seletManualStatus();
        if(manualStatus.equalsIgnoreCase("1")) {
            map.put("type", "recordalarm");
            traffAlarmRecord.setManualstatus(0);

        }else {
            map.put("type", "alarm");
            traffAlarmRecord.setManualstatus(1);
        }

        map.put("data", trffClientMessage);
        map.put("recordid", recordid);
        WebSocket.GroupSending(JsonUtil.beanToString(map));

        traffAlarmRecord.setProcessstatus("0");
        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        try {
            String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            Map<String, Object> transferRecordMap = new HashMap<>();
            FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
            List<TransferResult> results = FileTransferManager.transferFile(transferRecordMap, ftp, basepath);
            log.info("缓存数据上传结果：" + results.toString());
            Traffalarmrecord recordBak = FileTransferManager.traffAlarmRecordUrlUpdate(results);
            traffAlarmRecord.setImg2path(recordBak.getImg2path());
            traffAlarmRecord.setImg3path(recordBak.getImg3path());
            traffAlarmRecord.setImg4path(recordBak.getImg4path());
            traffAlarmRecord.setImg5path(recordBak.getImg5path());
            traffAlarmRecord.setVideopath(recordBak.getVideopath());

            if (traffAlarmRecord != null && traffAlarmRecord.getRecordid() != null) {
                traffAlarmRecordMapper.updateTraffAlarmRecordUrl(traffAlarmRecord);
            }

            //如果监控视频为空，延时加载重新获取
            if (null == recordBak.getVideopath() || "".equalsIgnoreCase(recordBak.getVideopath())) {

                schedulepool.schedule(() -> {
                    for (String key : transferRecordMap.keySet()) {
                        if (key.equals("videopath")) {
                            final String url = transferRecordMap.get(key).toString();
                            try {
                                HttpURLConnection connection = (HttpURLConnection) new URL(url).openConnection();
                                //延迟连接
                                connection.setReadTimeout(2000);
                                connection.setConnectTimeout(3000);
                                connection.setRequestMethod("GET");
                                String pname = DateUtils.formatCurrDayNoSign() + "_" + recordid + "_0000_" + key.replace("path", "");
                                String fileName = pname + ".mp4";
                                String ftputl = FTPUtil.getFtpUrl(ftp) + basepath + "/" + fileName;
                                if (connection.getResponseCode() == HttpURLConnection.HTTP_OK) {
                                    InputStream inputStream = connection.getInputStream();
                                    log.info("url:", url, " --- " + "key:", key);
                                    boolean r = FTPUtil.uploadFile(ftp, basepath, fileName, inputStream);
                                    if (r) traffAlarmRecord.setVideopath(ftputl);
                                    //只更新监控
                                    if (traffAlarmRecord != null && traffAlarmRecord.getRecordid() != null) {
                                        traffAlarmRecordMapper.updateTraffAlarmRecordUrl(traffAlarmRecord);

//                                        //推送给第三方
//                                        if(!manualStatus.equalsIgnoreCase("1")) {
//                                            ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffAlarmRecord);
//                                        log.info("send to guangda:HTTP_OK" + obj.toString());
//                                        }
                                    }
                                }
//                                else {
                                   // ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffAlarmRecord);
//                                    log.info("send to guangda HttpURLConnection.HTTP_Fail--->response message:" + obj.toString());
//                                }
                            } catch (IOException e) {
                                System.out.println(e.toString());
                                log.error(e.toString());
                                return 0;
                            }
                        }

                    }
                    return 1;
                }, 50, TimeUnit.SECONDS); //等待50秒钟执行


            } else {
                //需要先过滤，过滤结束后推送给第三方
//                if(!manualStatus.equalsIgnoreCase("1")) {
//                    ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffAlarmRecord);
//                   log.info("send to guangda novideopath --->response message" + obj.toString());
//                }

            }

        } catch (Exception e) {
            log.error("alarm fail :" + e.getMessage());
        }
    }

    private RateLimiter getRateLimiter(String videoId) {
        RateLimiter rateLimiter;
        if (rateLimiterMap.containsKey(videoId)) {
            rateLimiter = rateLimiterMap.get(videoId);
        } else {
            RateLimiter value = RateLimiter.create(rate);
                rateLimiter = rateLimiterMap.putIfAbsent(videoId, value);
            if (rateLimiter == null) {
                rateLimiter = value;
            }
        }
        return rateLimiter;
    }


    //车流量推送
    @PostMapping("/traffflow")
    public ResultObj traffflow(@RequestBody Vehicles vehicles) {

        if ("TRAFFIC_STATISTICS_VEHICLES".equalsIgnoreCase(vehicles.getType())) {
            String sbbh="";
            int tdbh=0;
            if(vehicles.getVideo_id().contains("_") && vehicles.getVideo_id().split("_").length == 2) {
                String[] sbAndTd = vehicles.getVideo_id().split("_");
                 sbbh = sbAndTd[0];
                 tdbh = Integer.valueOf(sbAndTd[1]) + 1;
            }
            else {
                sbbh=vehicles.getVideo_id();
            }
            //重置videoid
            vehicles.setVideo_id(sbbh + "_" + tdbh);
            //直接放入表中
            List<Vehiclesdetail> vels = vehicles.getObjs();
            int result = 0;
            for (Vehiclesdetail detail : vels) {
                Vehicle v = new Vehicle();
                v.setId(UUID.randomUUID().toString());
                v.setCreate_time(new Date(Long.valueOf(vehicles.getTs())));
                v.setType(detail.getType());
                v.setDirection(detail.getDirection());
                v.setRuleTag(detail.getRuleTag());
                v.setClassification_confidence(detail.getClassification_confidence());
                v.setVideo_id(vehicles.getVideo_id());
                result = traffFlowService.saveTraffFlowDetail(v);


            }
            //查询近五分钟的车流量，当天车流量websocket  直接推送过去
//            log.info("fivevehivle");
            //根据连接的name ，群发根据videoid  查询的结果
            webSocket.GroupSendingByVideoid(vehicles.getVideo_id());
        }
        return ResultObj.ok();
    }


    //获取自动规则
    @PostMapping("/autoRule")
    public ResultObj autoRule(@RequestBody AutoRule rules) {
        Map map = new HashMap();
        map.put("type", "rule");
        map.put("data", rules);
        webSocket.AppointSending(rules.getVideo_id(), JsonUtil.beanToString(map));
        return ResultObj.ok();
    }



    //获取flv地址
    @GetMapping("/getflv/{videoid}")
    public String getflv(@PathVariable("videoid") String videoid) {
        //根据id查询对应的rtsp
        String rtsp = traffFlowService.selectSbtddspsrRtspByVideoid(videoid);
        //huode  resid 中值、

        if (null != rtsp) {
            if (null == stringRedisTemplate.opsForValue().get(videoid)) {
//                log.info("flv-----");
                flvCacheService.getvalue(videoid, rtsp);
            }
//            log.info(stringRedisTemplate.opsForValue().get(videoid));
            JSONObject jsonObject = JSONObject.parseObject(stringRedisTemplate.opsForValue().get(videoid));

            if (null != jsonObject.getJSONArray("play_list") && jsonObject.getJSONArray("play_list").size() > 0) {
                return String.valueOf(jsonObject.getJSONArray("play_list").get(0));
            }

        }
        return "";


    }

    //自动车流量推送
    @PostMapping("/autotraffflow")
    public ResultObj autotraffflow(@RequestBody AutoVehicles vehicles) {

//        log.info("autotraffflow"+vehicles.toString());
        if ("TRAFFIC_STATISTICS_VEHICLES".equalsIgnoreCase(vehicles.getType())) {
            String[] sbAndTd = vehicles.getVideo_id().split("_");
            String sbbh = sbAndTd[0];
            int tdbh = Integer.valueOf(sbAndTd[1]) + 1;
            //重置videoid
            vehicles.setVideo_id(sbbh + "_" + tdbh);
            //直接放入表中
            List<AutoVehiclesdetail> vels = vehicles.getObjs();
            int result = 0;

            for (AutoVehiclesdetail detail : vels) {
                Vehicle v = new Vehicle();
                v.setId(UUID.randomUUID().toString());
                v.setCreate_time(new Date(Long.valueOf(vehicles.getTs())));
                v.setType(detail.getType());
                v.setDirection(detail.getDirection());
                v.setRuleTag(detail.getDirection().longValue()<=ldir.longValue()?"1":"2");
                v.setClassification_confidence(detail.getClassification_confidence());
                v.setVideo_id(vehicles.getVideo_id());
                result = traffFlowService.saveTraffFlowDetail(v);
            }
            //查询近五分钟的车流量，当天车流量websocket  直接推送过去
            //根据连接的name ，群发根据videoid  查询的结果
            webSocket.GroupSendingByVideoid(vehicles.getVideo_id());
        }
        return ResultObj.ok();
    }

    //车流量推送
    @GetMapping("/sendtouser/{recordid}")
    @ResponseBody
    public Integer sendtouser(@PathVariable("recordid") String  recordid) {
        //查询该信息
        Traffalarmrecord traffalarmrecord = traffAlarmRecordMapper.selectByPrimaryKey(recordid);
        if(traffalarmrecord==null) return 0;
        Alarm alarm=new Alarm();
        Base64Encoder base64Encoder=new Base64Encoder();
        alarm.setTs(Long.toString(traffalarmrecord.getRecordtime()==null?new Date().getTime():traffalarmrecord.getRecordtime().getTime()));
        alarm.setDept(traffalarmrecord.getAreaid()==null?null:Long.toString(traffalarmrecord.getAreaid()));
        alarm.setVideo_id(traffalarmrecord.getFdid()+"_"+traffalarmrecord.getChannelid());
        alarm.setIncident_type(traffalarmrecord.getRecordtype());
        List<String> strImgs=new ArrayList<>();
        if(traffalarmrecord.getImg1path() != null ){
            byte[]  Img=FTPUtil.getFtpPicBytes(traffalarmrecord.getImg1path());
            strImgs.add(Img!=null?base64Encoder.encode(Img) : null);
        }

        if(traffalarmrecord.getImg2path() != null ){
            byte[]  Img=FTPUtil.getFtpPicBytes(traffalarmrecord.getImg2path());
            strImgs.add(Img!= null ? base64Encoder.encode(Img) : null);
        }
        if(traffalarmrecord.getImg3path() != null ) {
            byte[] Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg3path());
            strImgs.add(Img != null ? base64Encoder.encode(Img) : null);

        }
        if(traffalarmrecord.getImg4path() != null ) {
            byte[] Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg4path());
            strImgs.add(Img != null ? base64Encoder.encode(Img) : null);
        }
        if(traffalarmrecord.getImg5path() != null ) {
            byte[] Img = FTPUtil.getFtpPicBytes(traffalarmrecord.getImg5path());
            strImgs.add(Img != null ? base64Encoder.encode(Img) : null);
        }

        alarm.setImg_base64(strImgs);
        Map  map=new HashMap();
        //websocket  推送给客户
        map.put("type", "alarm");
        map.put("data", alarm);
        map.put("recordid", recordid);
        WebSocket.GroupSending(JsonUtil.beanToString(map));

        try {
            //推送给第三方
            ResultObj obj = eventWriteService.updateAndAutoSendEvent(traffalarmrecord);
            log.info("send to guangda novideopath --->response message" + obj.toString());

            if (obj.getStatus() == 200) {
                return 1;
            } else {
                return 0;

            }

        }catch (Exception  ex){
            log.info("send to guangda novideopath --->response error" + ex.toString());

            return 1;

        }



    }



    //车流量推送
    @GetMapping("/test")
    @ResponseBody
    public void test() {
        String  manualStatus=traffAlarmRecordMapper.seletManualStatus();
        Alarm alarm=new Alarm();
        alarm.setVideo_id("33_65_230_156_554_fbXdTkVe98u_ecvs_0");
        alarm.setIncident_type("NO_MOTOR_BAN");
        String   str="iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAB1UlEQVRIS5WVjTEEQRBG30WACBABGSACLgJEgAicCBABIkAEiIAMkAERUG9remtua2Z3rquuam935nvTPf0zY9y2gENgH/B5Ny3/AL6AV+A5PReVZhV9xS6Bk/RdEUVzE7qXXtwDVyVQCaDoNeC3m/T7qRxkHThPvz9gnrzqlw8Bi3RyTyyoJjzkCTJcO8ApoEed5QAF74CHLDRDofwOShA9PgYOwpMAGPN34A04Grl3T6kZ/5KFJ5vAthEIgC4pLGgsLFMAoWp8pktfCFh6MZG2LQAlPLDpvS3ALDBrNhoutRUQh54LcJNhGYt9ONYKcH1XiAJ80CVTdMpWATwB6wIsEKswALpnupZsLE1dfwsorKl3WAP0hTKgCDcFTeeSWQc5YF+APcaXLSGKSq/1sBzah6h7GCmefNMqgP6SV0nTVsBSmq5SaK2A6AxdFi1V3kSxtQDMNPtal5l5s/Oy7SF2wlo/EmBIvbOS+f4ldQVBfbNzsR3Sj7p3UYG4yZBGKuaQELeLqtVNwGG6xUzwo9PJTGgxwY/p5HpYHDghJN0TrqVxaXXWQAqfpQH1nfrZ0uyuFUw+awUJcGNsVjjC9Ts2u6cqMgowhpH/IwGE2fxK99GH9R91mncY+HKoHAAAAABJRU5ErkJggg==";
        List arrlist=new ArrayList();
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        arrlist.add(str);
        alarm.setImg_base64(arrlist);
        alarm.setTs("1345677777");
        alarm.setType("TRAFFIC_INCIDENT_ALARM");
        Map  map=new HashMap();
        map.put("type", "alarm");
        map.put("data", alarm);
        map.put("recordid", "33448");
        WebSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord=new  Traffalarmrecord();
        traffAlarmRecord.setRecordid(Long.parseLong("33448"));
        traffAlarmRecord.setChannelid(new Integer(1));
        traffAlarmRecord.setFdid("20200305112042989");
        traffAlarmRecord.setRecordtype("NO_MOTOR_BAN");

//        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        map.put("recordid", "33449");
        WebSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord2=new  Traffalarmrecord();
        traffAlarmRecord2.setRecordid(Long.parseLong("33449"));
        traffAlarmRecord2.setChannelid(new Integer(1));
        traffAlarmRecord2.setFdid("20200305112042989");
        traffAlarmRecord2.setRecordtype("WRONG_DIRECTION");

//        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord2);
    }

    //车流量推送
    @GetMapping("/test2")
    @ResponseBody
    public void test2() {
        Alarm alarm=new Alarm();
        alarm.setVideo_id("33_65_230_156_554_fbXdTkVe98u_ecvs_0");
        alarm.setIncident_type("vehicle_ban");
        alarm.setType("TRAFFIC_INCIDENT_ALARM");
        Map  map=new HashMap();
        map.put("type", "alarm");
        map.put("data", alarm);
        map.put("recordid", "3344656");
        WebSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord=new  Traffalarmrecord();
        traffAlarmRecord.setRecordid(Long.parseLong("33446"));
        traffAlarmRecord.setChannelid(new Integer(0));
        traffAlarmRecord.setFdid("33_65_230_156_554_fbXdTkVe98u_ecvs");
        traffAlarmRecord.setRecordtype("vehicle_ban");

        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        map.put("recordid", "3344766");
        WebSocket.GroupSending(JsonUtil.beanToString(map));
        Traffalarmrecord traffAlarmRecord2=new  Traffalarmrecord();
        traffAlarmRecord2.setRecordid(Long.parseLong("33447"));
        traffAlarmRecord2.setChannelid(new Integer(0));
        traffAlarmRecord2.setFdid("33_65_230_157_554_pKf3kS8Vo0N_ecvs");
        traffAlarmRecord2.setRecordtype("vehicle_ban");

        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord2);
    }

    @GetMapping("/getrealcamerasnapshot")
    @ResponseBody
    public String index(@RequestParam("url") String  url,
                        @RequestParam("refresh") String refresh) {
        return  "{\"ret\": 0," +
                "\"desc\": \"succ!\"," +
                "\"url\": \"http://localhost:8089/snapshot/11111.jpg\"" +
                "}";
    }


    @PostMapping("/images/recog")
    @ResponseBody
    public String images(@RequestBody GoalStructureParam param) {
       return "{\"ret\":\"200\",\"error_msg\":\"OK\",\"ObjectList\":[{\"ImageID\":\"1\",\"ObjectID\":1,\"Metadata\":{\"Gender\":\"1\",\"Age\":\"32\",\"Angle\":\"128\",\"HeadBoundingBox\":{\"x\":96,\"y\":16,\"w\":107,\"h\":136},\"FaceBoundingBox\":{\"x\":115,\"y\":61,\"w\":57,\"h\":77},\"UpperBoundingBox\":{\"x\":34,\"y\":123,\"w\":232,\"h\":263},\"LowerBoundingBox\":{\"x\":74,\"y\":309,\"w\":176,\"h\":408},\"CoatLength\":\"2\",\"CoatTexture\":\"1\",\"CoatColor\":[\"2\"],\"CoatColorNums\":\"1\",\"TrousersLength\":\"1\",\"TrousersTexture\":\"1\",\"TrousersColor\":[\"5\"],\"TrousersColorNums\":\"1\",\"HairStyle\":\"2\",\"HasHat\":\"1\",\"HasGlasses\":\"0\",\"HasMask\":\"0\",\"HasBackpack\":\"0\",\"HasCarrybag\":\"0\",\"HasUmbrella\":\"0\",\"HasTrolley\":\"-1\",\"HasLuggage\":\"-1\",\"LuggageColor\":[],\"LuggageColorNums\":\"0\",\"HasKnife\":\"-1\",\"ObjectBoundingBox\":{\"x\":26,\"y\":13,\"w\":256,\"h\":708},\"TrafficViolation\":\"-1\",\"Type\":\"1\"},\"Feature\":\"UVNURgUA//0BCP4BAQcAAwQBBvsCB/v8Af4A+wD5+AcBAgL9AgIEAgH4AQQA+f77+P77AAAIA/8A+QQJ/fz8AgACBfsAAgAC/AcIAQD++fgCAAUB/gb//AEAAf4B/QP+AQD0/QMDAfkD+f//A/7+/AD6B/f7/AH7/gAFAAMBAPb/AAP//wAIBQD7Af0FAAD9AAgC/gYF/f/8DAAC//4BAP/6AgECAgADAPz++v0A/wD//fz5AAIB/f0IBAQA/v8CBwP//wYE+/sCCP0BBAMD/gQA/QH/AgL6AgX/BP7/+AD5A/75/QH+A/8H/QAACP//AQT7+QICAfv/Afj9A/0D/wAA/f/8/wYL/wACAQYAAAAD/ggAAQMABv/6BAIADPv+A/wEAQAA/AD5AwT///4BAPz8CgUCDf78AwEA/f4AA/8C/wQB/P8A/wEA/gsAAwEF/v0AAf7/+QQECAcGAP0AAgH//AAHBwD3/fwB+/7/AQj//wUFAP/+/gYBAgYD+fv/BwH8Af0EBAD+AP3++gIH+v8CAPQEAAT//gDzAP0A+AL6BP4I9wMJAP0CAPX6APz9/gALAP7/BgQD+wIDBPn+CwIH/fz7A/3+9wAJ/QD9AP/++wME/v/+Avv+APoFAAAB+gD5APn//gEGBAME/wX5/AD/CAL+9QD8BAD2/wMCCf38+/oB+f0C/f39AQL+AAEAAgAE/wEIA///AP8HAQT+8fn7AP4AAAMA+QQDAwIB//j+/QEAAAIAAgj/A/n8AAP9AQD8AQYF+PgAA/4B+gEE+QYA/wYAB/0BAQD+/P/+BQf5BwIAAPsBBAEGAP4JAwEE////AAEF/wL4AAAFAQYA/vz+/AACAv8CAwIA+wIAAAUJAP0C/wIHAAEABgQF/QAEAAL7BP0A//wC+vr+/AIGAwAEAP0A/P/8BAD//AD5+wQEAAEHAv/8AP77+vQEBP4BAAAAAAr7/wD5AgD7BAEA/gT7AAAEAAMABPkLAQYABff+/wEDAP8EA/4AAf8A/gX9+wACAv3//f7/BAH+Bf/+AAH/AAAE9wAHAP/+/P8DAQD7/QQB/P3/AwAAAQAB/wD+BwAB/vwAAAL/AAYAAAf/Af76+fj6AP4F/gD9AgIB/Qr59f8CAAMCBgQHAf0FAP34AAQH/P79/wQGBA4D+f4AA/v+AAAA+wIE/gIH+QP2AQQGAwAE/vwI/P4GBwD/AAX4AAP+/f0A/Af/AgEBA/v9BPgDBwAC/wD8Bv36A/gBAAH+AAX+BP/9AAIF+AD8Av4B/wT/AQAAAQL/BPwA/PsA/AMDBfb/+AEBCAL+//36APz//wEHBv3/BQAA/QP9+wABAQL6//4CAAH/CP/+AAMBAf0CAAD9+g==\",\"BucketID\":32,\"BucketIDList\":[32,87,20,68,45,78,10,6,52,65,1,94,79,16,61,38,55,89,43,51,60,27,54,25,17,83,9,40,14,22,50,44,18,66,82,4,48,31,69,77,90,63,92,73,70,84,67,23,12,3,74,47,21,41,28,96,36,97,5,85,39,95,64,26,80,53,91,37,34,57,46,15,2,93,11,98,75,81,56,0,24,62,86,13,19,71,72,7,58,29,59,49,88,76,35,99,33,30,42,8],\"FaceFeature\":\"AwQF+foK/vcCAAD4/wD7CQH39vP7/gz/CAAB/AX++AAI/v8D+gQAAP0G/wAA+/oAAAP+Af79CwEAAgAA+/oFBe/3AgIFAgP0/vr8Cf4C+AMHBPn5Afr5AQQGBQD58gMG+wQTAgTzAPr9BQYEA/j//gT8+wXx9wMC+gcH/wAC8v0A+gD7+wkE/gAA7wL78gX/AgIGBvr8AAgD/woEAvkEAwv5CP/8/fz+/fwMAvr7AgD4APcEAA0F//kAAAAG+gADAQEB/wD+AQgCBg35+QQC/vv//vcAAPgEAwAAAgD9Af32/wMLAwD8B/75AQIB+/z/+v4AA/n//gL8+/0BAPv//PgIAAD0CQALAAUF/fwA/wYBAQf9+/f++Af49gMB/AMABwAA9vr5//sE/PoD+QP6+wsA/wEB+QIC+/8B/wD88QkACAIAAPn5AAUD/QL++P4H/f3+A/gG/f8G/QkA8wD0BAMBBwD59AAB+QUA//v2/wEJAQD8DAL5CPoA+/b+/Qr5AwcA/AD+CAEDBgEH/Qb+AQUHAAQK/fUA+/sI9/0I+QcKBQP6/gX0+QgI9gIBAAMFAAAA/vcD/vYI9wj9+v76C/gAAgIH+gMHBP8IAAT6BgAI+vsJ/v7/DAUABgIA+gAHBf0D+/oDAwEABv359QAB+AEG8w7+//0ABf78CPr8Afs=\",\"FaceBucketID\":91,\"FaceBucketIDList\":[91,12,50,84,52,13,57,54,4,53,70,36,64,58,81,10,78,63,35,75,34,16,86,3,99,40,26,42,48,30,25,23,11,62,72,51,18,17,46,27,97,61,49,43,66,37,89,19,24,1,98,76,32,83,44,96,87,31,8,20,33,21,6,56,41,88,82,47,69,93,14,79,38,29,80,85,90,94,55,60,67,95,9,2,71,65,68,77,7,74,59,28,92,73,15,39,22,0,45,5],\"FaceQuality\":\"0.379721\",\"FaceYaw\":\"-0.135311\",\"FacePitch\":\"0.508456\",\"FaceRoll\":\"0.000000\",\"FaceBlurry\":\"0.555109\",\"ObjectImageData\":\"\",\"FaceImageData\":\"\",\"Index\":1},{\"ImageID\":\"7\",\"ObjectID\":1,\"Metadata\":{\"Angle\":\"128\",\"VehicleClass\":\"1\",\"VehicleColor\":[\"9\"],\"VehicleColorNums\":\"1\",\"VehicleBrand\":\"\\u96ea\\u4f5b\\u5170-\\u79d1\\u9c81\\u5179-2009_2013\",\"VehicleMainBrandName\":\"\\u96ea\\u4f5b\\u5170\",\"VehicleSubBrandName\":\"\\u79d1\\u9c81\\u5179\",\"VehicleYearName\":\"2009_2013\",\"HasPlate\":\"1\",\"PlateClass\":\"1\",\"PlateColor\":\"2\",\"PlateNo\":\"\\u6d59AJ079B\",\"PlateNeatness\":\"2\",\"Sunvisor\":\"0\",\"Paper\":\"0\",\"Decoration\":\"0\",\"Drop\":\"1\",\"Tag\":\"1\",\"SafetyBelt\":{\"MainDriver\":\"-1\",\"CoDriver\":\"-1\"},\"HasCall\":\"-1\",\"HasSkylight\":\"0\",\"HasBaggage\":\"0\",\"HasAerial\":\"0\",\"HasCrash\":\"-1\",\"HasDanger\":\"0\",\"HighwayTollVehicles\":\"1\",\"ObjectBoundingBox\":{\"x\":41,\"y\":40,\"w\":894,\"h\":717},\"TrafficViolation\":\"-1\",\"Type\":\"2\"},\"Feature\":\"AAAAAAAAAAAAAAAPAAAAAAAKABQAAAAAAAAAAAAAAAAhAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAHwAAAAAAAAAAAAAAAAAAAAAHAAAAAAAAAAAAAAAAAAAAAAAAAB0AAAAAAAAAAAAAEwELAAAAAAAAAAAAAAAAAAAAAAAFCQkAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAARAAAAABIAAAAAABMAAAEAAAAAAAAAAAAAAAAAABAAGQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPAAAAAAAAAAAAAAAAAAAAAAARAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAZAAAAHgAAAAAAAAAAAAAAAgAAAAAHAAATAAAAAAAAAAAAAAAsAAAAAAAAAAAAAAAAAAAAAAAcAAAAAB8AAAAAAAAAAAAAAAAAAAAAABoDAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAVAAAAAAAMDgAAAAAAAB0AAAAAAAAAAAAADwAAAAAAAAAAAAAAAAAAAAA=\",\"BucketID\":76,\"BucketIDList\":[76,91,82,57,36,51,75,55,71,43,84,63,8,98,83,65,90,60,35,3,37,39,74,2,12,9,1,20,79,32,95,49,33,58,42,66,38,69,45,56,59,0,87,19,41,34,21,14,13,6,4,26,68,96,72,7,85,29,48,40,88,99,23,46,27,18,77,78,11,97,17,50,15,61,16,31,80,44,52,25,10,86,92,5,54,53,73,89,94,93,70,62,30,47,64,22,28,67,81,24],\"FaceFeature\":\"\",\"FaceBucketID\":-1,\"FaceBucketIDList\":[],\"FaceQuality\":\"0.000000\",\"FaceYaw\":\"0.000000\",\"FacePitch\":\"0.000000\",\"FaceRoll\":\"0.000000\",\"FaceBlurry\":\"0.000000\",\"ObjectImageData\":\"\",\"FaceImageData\":\"\",\"Index\":1},{\"ImageID\":\"4\",\"ObjectID\":1,\"Metadata\":{\"Gender\":\"1\",\"Age\":\"16\",\"Angle\":\"128\",\"BikeClass\":\"1\",\"SocialAttribute\":\"1\",\"Enterprise\":\"-1\",\"FaceBoundingBox\":{\"x\":145,\"y\":65,\"w\":54,\"h\":66},\"CoatLength\":\"2\",\"CoatTexture\":\"5\",\"CoatColor\":[\"2\"],\"CoatColorNums\":\"1\",\"HelmetColor\":\"-1\",\"HasHelmet\":\"0\",\"HasGlasses\":\"1\",\"HasMask\":\"0\",\"HasBackpack\":\"0\",\"HasCarrybag\":\"-1\",\"HasUmbrella\":\"0\",\"HasPlate\":\"-1\",\"PlateNo\":\"-1\",\"HasPassenger\":\"1\",\"ObjectBoundingBox\":{\"x\":54,\"y\":16,\"w\":276,\"h\":635},\"TrafficViolation\":\"-1\",\"Type\":\"4\"},\"Feature\":\"UVNURgUA/wACAf/3AfwEA/kC/AMAAwAEAQACAPv+AAAB/wMHAgEA/wAGAAj/+AD7APwCAwkD9wsAAP4CBvn7/wz5A/wBBP8D/QICCAUCBv/7AgABAv7+AAH9AAUC/AX/AvsC/P4CAv39BAMA/gAAAAIA/wT6/v77A/YEAPoB//sG//7+/wD+/QAA/AMAAAQCAvz8/P3/AAH9+gX8/wD8/fr7AQAD//oA+AECAAAFAAH+/QH7/gIHAgYA/vz+AwADAgQCAgAL+wD9BgMGBv8E+/oF/P4H/wMD/gQC/wQH/v/4Agn9BQAC/wAE/P37BP/7AgIA/gj8APv7CAL9/vkABgL7/fz9/AD1BwD7AwAAAwH7AAb7+v4AAwX6/PsDBwMA/wH9AQD8AQP8APz7/vb8APoDAAT8AP0FAwYG/P39/P4B/vkA/f8AAgQBB/0D+wAFBwX4Aff+Bvz2/wEEBAIABQQD/wABAAMA//0AAP/+/wAC9/4AAfz+AAEF/f/6CAD9Bfn/APn9CwP3BAABBAAIAfr8/wP/CQn9BgL+Bf38A/z89gf6AAf9//wABAP9AgT19/4DAQMCAQQDAAABBf76+gEC/Pv9//4E//76AAAACQAA//kE//sDCfsGA/z7AAD7BAMAAAIAAgMA/P0D/wIE/v36//wAAgX8/voCAAT8BAkCAgEBAfwG+gEA/vr++AYAAQL7AAcAAP8BAAH9Af8A+QD+Agj7+wID/AAB+QcD//4ACQMEAvv+AvwBB/r7/gL/+AL7A/78+/4AAP39/QEFAwEA/QECCfz6AfwE/QMAAwD/Av4HAPz/AP4F/ggD+gMH+/UH+wID/wQGBPr2BP8KBAP/+/7//AP2/QT6//4CBAAFBgAFBf4E//v9BgADAAH9/gb4BAQHAAEA/QIB/vsE+/8GAPb7Av79AAD4AP4B+wf+/P4ABf79/wD/+QQA+fkB/voAA/oDAQUDAP79BAkGAAn/AQMB//76APz8BQD9AgEB/Pf6/wcAAwcHAgEA/QH/AP/6A/75BP8E/QD+AgT+AwEF+PkC//37/f79/gAAAQUA+AEEAAX9/wL8AgAFAwAA+v8G+wQA/QEF/wD+BAAGAwABAf0JAgMD+wUGAf39APoA/gQHAAID/AAF//8GA//8/QUC/gEC/vwGAv0BAAD9/ggCAAYBAwL/AQD9/fYD/wIE/f/4BP4AAAD8+wH5Bwb7AAQF+v/0//j9+/v/AP4CAgAA/v4AAP7+Bfv/CwECAQD7CgH5AQEAAQQAAP76APkABQIBBv0JAwABBwD++wD+//35+QPy/v0FAAYC+QD9Avr5CgQIA/35/AADAQH6+AEIAwEEAAMA/AMD+wADAAP///kFBAEBAA==\",\"BucketID\":5,\"BucketIDList\":[5,3,83,30,43,82,55,80,46,51,61,79,97,67,21,91,88,90,99,12,23,0,1,36,47,54,37,27,14,50,16,8,53,25,52,29,18,60,38,98,62,4,15,2,20,22,17,96,65,44,75,59,93,66,31,10,45,48,13,7,57,76,72,77,56,94,81,87,95,6,92,69,74,39,35,26,34,71,41,85,64,49,24,42,73,78,58,63,89,11,86,68,32,28,19,9,40,33,70,84],\"FaceFeature\":\"BQD5+Af/BP4I/AD7AP/9AAcC/QT6/P4HAfr9B/sIBf8O/AD8BwYKCA0AAv77/gAE+gAL/wMA/QD9AAAG/vv8AAP7BvwBAAn4AAf/AQAOAP8A7wIBAv8EAwAFAf/5CPoABQEDBwEFBQb5/fb+AO4G+AAB/wML9PsAA/oHBwYF/Pz7/gUK9QUABgEE+wH8AgL6+gb3AwEAAxL7CwD/DPcFAf30AAPz/QAE/QAABvn9AwD2/wQCAwACAQAKBAUD/v0A/voE//0B+Ab//vkC+vj/AAH7+AL7A/sDAPj7Bvn+/QoGAwEA/v//AP4D+wQDAf8K/QP2BgD5/QD//gEKA/v+BwAAAf3xAf/+/gT9AwP8DADzBw4AAvn//wAE+QH5AQv3C+38/Pf9/QII8gID9wMFCggFAv/9AvsEBvkACP8G9/z9AP/7/fwE+v39DPgAAAAB/fr5A/n8/wIDAAQK/wH+AwAAAvwADQoKAgAFAfsF+vsE//35C/3zCAD9BPsB/wMGB/n5/Pv0+Pb+BPn5/wMKAQAB8fT9Awf++/YAAAICAwUG+wD0+fkBB/0AAAQIBfgEBPkG/wcJAgD7CAv1Avf9AQYAAAEDAPYC+foJ+/78APwD8f4A/gUBB/7///oLAwD/AAUD+/39+PsH+QIF9gMEA/oGAQsMBQkHA/wB+PwCAgA=\",\"FaceBucketID\":82,\"FaceBucketIDList\":[82,45,63,31,16,1,7,98,40,24,65,19,62,48,94,72,92,17,91,52,77,76,85,87,81,21,93,64,37,42,30,78,25,61,9,12,22,2,13,34,4,15,46,3,14,99,90,28,66,29,75,68,80,59,60,88,69,83,36,55,11,44,96,89,10,26,49,50,73,6,53,20,47,86,58,84,27,8,70,43,57,71,97,79,0,67,54,33,23,95,56,5,41,38,51,32,74,39,35,18],\"FaceQuality\":\"0.365118\",\"FaceYaw\":\"0.257412\",\"FacePitch\":\"0.390233\",\"FaceRoll\":\"0.000000\",\"FaceBlurry\":\"0.475882\",\"ObjectImageData\":\"\",\"FaceImageData\":\"\",\"Index\":1},{\"ImageID\":\"1\",\"ObjectID\":1,\"Metadata\":{\"Gender\":\"1\",\"Age\":\"32\",\"HeadBoundingBox\":{\"x\":96,\"y\":16,\"w\":107,\"h\":136},\"FaceBoundingBox\":{\"x\":115,\"y\":61,\"w\":57,\"h\":77},\"HairStyle\":\"2\",\"HasHat\":\"1\",\"HasMask\":\"1\",\"HasGlasses\":\"0\",\"Type\":\"3\"},\"Feature\":\"UVNURgUA//0BCP4BAQcAAwQBBvsCB/v8Af4A+wD5+AcBAgL9AgIEAgH4AQQA+f77+P77AAAIA/8A+QQJ/fz8AgACBfsAAgAC/AcIAQD++fgCAAUB/gb//AEAAf4B/QP+AQD0/QMDAfkD+f//A/7+/AD6B/f7/AH7/gAFAAMBAPb/AAP//wAIBQD7Af0FAAD9AAgC/gYF/f/8DAAC//4BAP/6AgECAgADAPz++v0A/wD//fz5AAIB/f0IBAQA/v8CBwP//wYE+/sCCP0BBAMD/gQA/QH/AgL6AgX/BP7/+AD5A/75/QH+A/8H/QAACP//AQT7+QICAfv/Afj9A/0D/wAA/f/8/wYL/wACAQYAAAAD/ggAAQMABv/6BAIADPv+A/wEAQAA/AD5AwT///4BAPz8CgUCDf78AwEA/f4AA/8C/wQB/P8A/wEA/gsAAwEF/v0AAf7/+QQECAcGAP0AAgH//AAHBwD3/fwB+/7/AQj//wUFAP/+/gYBAgYD+fv/BwH8Af0EBAD+AP3++gIH+v8CAPQEAAT//gDzAP0A+AL6BP4I9wMJAP0CAPX6APz9/gALAP7/BgQD+wIDBPn+CwIH/fz7A/3+9wAJ/QD9AP/++wME/v/+Avv+APoFAAAB+gD5APn//gEGBAME/wX5/AD/CAL+9QD8BAD2/wMCCf38+/oB+f0C/f39AQL+AAEAAgAE/wEIA///AP8HAQT+8fn7AP4AAAMA+QQDAwIB//j+/QEAAAIAAgj/A/n8AAP9AQD8AQYF+PgAA/4B+gEE+QYA/wYAB/0BAQD+/P/+BQf5BwIAAPsBBAEGAP4JAwEE////AAEF/wL4AAAFAQYA/vz+/AACAv8CAwIA+wIAAAUJAP0C/wIHAAEABgQF/QAEAAL7BP0A//wC+vr+/AIGAwAEAP0A/P/8BAD//AD5+wQEAAEHAv/8AP77+vQEBP4BAAAAAAr7/wD5AgD7BAEA/gT7AAAEAAMABPkLAQYABff+/wEDAP8EA/4AAf8A/gX9+wACAv3//f7/BAH+Bf/+AAH/AAAE9wAHAP/+/P8DAQD7/QQB/P3/AwAAAQAB/wD+BwAB/vwAAAL/AAYAAAf/Af76+fj6AP4F/gD9AgIB/Qr59f8CAAMCBgQHAf0FAP34AAQH/P79/wQGBA4D+f4AA/v+AAAA+wIE/gIH+QP2AQQGAwAE/vwI/P4GBwD/AAX4AAP+/f0A/Af/AgEBA/v9BPgDBwAC/wD8Bv36A/gBAAH+AAX+BP/9AAIF+AD8Av4B/wT/AQAAAQL/BPwA/PsA/AMDBfb/+AEBCAL+//36APz//wEHBv3/BQAA/QP9+wABAQL6//4CAAH/CP/+AAMBAf0CAAD9+g==\",\"BucketID\":32,\"BucketIDList\":[32,87,20,68,45,78,10,6,52,65,1,94,79,16,61,38,55,89,43,51,60,27,54,25,17,83,9,40,14,22,50,44,18,66,82,4,48,31,69,77,90,63,92,73,70,84,67,23,12,3,74,47,21,41,28,96,36,97,5,85,39,95,64,26,80,53,91,37,34,57,46,15,2,93,11,98,75,81,56,0,24,62,86,13,19,71,72,7,58,29,59,49,88,76,35,99,33,30,42,8],\"FaceFeature\":\"AwQF+foK/vcCAAD4/wD7CQH39vP7/gz/CAAB/AX++AAI/v8D+gQAAP0G/wAA+/oAAAP+Af79CwEAAgAA+/oFBe/3AgIFAgP0/vr8Cf4C+AMHBPn5Afr5AQQGBQD58gMG+wQTAgTzAPr9BQYEA/j//gT8+wXx9wMC+gcH/wAC8v0A+gD7+wkE/gAA7wL78gX/AgIGBvr8AAgD/woEAvkEAwv5CP/8/fz+/fwMAvr7AgD4APcEAA0F//kAAAAG+gADAQEB/wD+AQgCBg35+QQC/vv//vcAAPgEAwAAAgD9Af32/wMLAwD8B/75AQIB+/z/+v4AA/n//gL8+/0BAPv//PgIAAD0CQALAAUF/fwA/wYBAQf9+/f++Af49gMB/AMABwAA9vr5//sE/PoD+QP6+wsA/wEB+QIC+/8B/wD88QkACAIAAPn5AAUD/QL++P4H/f3+A/gG/f8G/QkA8wD0BAMBBwD59AAB+QUA//v2/wEJAQD8DAL5CPoA+/b+/Qr5AwcA/AD+CAEDBgEH/Qb+AQUHAAQK/fUA+/sI9/0I+QcKBQP6/gX0+QgI9gIBAAMFAAAA/vcD/vYI9wj9+v76C/gAAgIH+gMHBP8IAAT6BgAI+vsJ/v7/DAUABgIA+gAHBf0D+/oDAwEABv359QAB+AEG8w7+//0ABf78CPr8Afs=\",\"FaceBucketID\":91,\"FaceBucketIDList\":[91,12,50,84,52,13,57,54,4,53,70,36,64,58,81,10,78,63,35,75,34,16,86,3,99,40,26,42,48,30,25,23,11,62,72,51,18,17,46,27,97,61,49,43,66,37,89,19,24,1,98,76,32,83,44,96,87,31,8,20,33,21,6,56,41,88,82,47,69,93,14,79,38,29,80,85,90,94,55,60,67,95,9,2,71,65,68,77,7,74,59,28,92,73,15,39,22,0,45,5],\"FaceQuality\":\"0.379721\",\"FaceYaw\":\"-0.135311\",\"FacePitch\":\"0.508456\",\"FaceRoll\":\"0.000000\",\"FaceBlurry\":\"0.555109\",\"ObjectImageData\":\"\",\"FaceImageData\":\"\",\"Index\":1}]}";}

}
