package com.hzjt.util;

import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Months;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Date;

/**
 * ʱ���ʽת���� 2019.10.23
 * @author cp
 */
public class DateUtils {
    private static final DateTimeFormatter YMD_HMS = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter YMDHMS = DateTimeFormat.forPattern("yyyyMMddHHmmss");
    private static final DateTimeFormatter YMD = DateTimeFormat.forPattern("yyyyMMdd");
    private static final DateTimeFormatter Y_M_D = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static String formatCurrDate(){
        return formatCurrDateByType(YMD_HMS);
    }

    public static String formatCurrDateNoSign(){
        return formatCurrDateByType(YMDHMS);
    }

    public static String formatCurrDateYMD(){
        return formatCurrDateByType(Y_M_D);
    }

    public static String formatCurrDayNoSign(){
        return formatCurrDateByType(YMD);
    }

    public static Date parseDate(String date){
        return DateTime.parse(date,YMD_HMS).toDate();
    }

    public static Date parseDateNoSign(String date){
        return DateTime.parse(date,YMDHMS).toDate();
    }

    public static String getYesterday(int day){
        Date date= addDay(new Date(),day);
        return new DateTime(date).toString(YMD_HMS);
    }

    public static String getlastMonth(int month){
        Date date= addMonth(new Date(),month);
        return new DateTime(date).toString(YMD_HMS);
    }

    public static String formatDate(Date date){
        return new DateTime(date).toString(YMD_HMS);
    }

    public static String formatDateToNoSign(Date date){
        return new DateTime(date).toString(YMDHMS);
    }

    public static String formatDateToNoSign(String date){
        return DateTime.parse(date,YMD_HMS).toString(YMDHMS);
    }

    private static String formatCurrDateByType(DateTimeFormatter dateTimeFormatter){
        return DateTime.now().toString(dateTimeFormatter);
    }

    public static Date addMinutes(Date date, int minutes) {
        return new DateTime(date).plusMinutes(minutes).toDate();
    }

    public static Date addDay(Date date, int day) {
        if(day == 0){
            return date;
        }
        return new DateTime(date).plusDays(day).toDate();
    }

    public static Date addMonth(Date date, int month) {
        if(month == 0){
            return date;
        }
        return new DateTime(date).plusMonths(month).toDate();
    }

    /**
     * ����ʱ����������
     * @param date1 ʱ��1
     * @param date2 ʱ��2
     * @return ����
     */
    public static int diffMonth(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        DateTime dt1 = new DateTime(date1);
        DateTime dt2 = new DateTime(date2);
        return Months.monthsBetween(dt1, dt2).getMonths();
    }

    /**
     * ����ʱ����������
     * @param date1 ʱ��1
     * @param date2 ʱ��2
     * @return ����
     */
    public static int diffDay(Date date1, Date date2) {
        if (date1 == null || date2 == null) {
            return 0;
        }
        DateTime dt1 = new DateTime(date1);
        DateTime dt2 = new DateTime(date2);
        return Days.daysBetween(dt1, dt2).getDays();
    }


}
