/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMapMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;
import oracle.sql.ORAData;

public class AQjmsMapMessage
extends AQjmsMessage
implements MapMessage {
    private byte[] m_bytesData = new byte[0];
    private HashMap m_map;
    private boolean m_dirty = false;

    public AQjmsMapMessage() {
        super(true);
        this.m_map = new HashMap();
        this.m_dirty = true;
        this.access_mode = 2;
    }

    AQjmsMapMessage(AQjmsSession session) {
        super(session, true);
        this.m_map = new HashMap();
        this.m_dirty = true;
        this.access_mode = 2;
    }

    AQjmsMapMessage(AQjmsMessage headerMsg) {
        super(headerMsg);
        this.m_map = new HashMap();
        this.m_dirty = true;
    }

    AQjmsMapMessage(AQjmsSession session, AQjmsMapMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readMapMessageContainer(msgCont);
            this.m_dirty = false;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsMapMessage(AQjmsSession session, AQjmsGenMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readGenMessageContainer(msgCont);
            this.m_dirty = false;
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsMapMessage(AQjmsSession session, byte[] bdata) throws JMSException {
        super(session, true);
        if (bdata != null) {
            this.m_bytesData = bdata;
        }
        this.m_dirty = false;
        this.access_mode = 0;
    }

    byte[] getHashTable() throws JMSException {
        this.updateBytesDataFromMap();
        return this.m_bytesData;
    }

    public void setBoolean(String name, boolean value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Boolean(value));
        this.m_dirty = true;
    }

    public void setByte(String name, byte value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Byte(value));
        this.m_dirty = true;
    }

    public void setShort(String name, short value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Short(value));
        this.m_dirty = true;
    }

    public void setChar(String name, char value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Character(value));
        this.m_dirty = true;
    }

    public void setDouble(String name, double value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Double(value));
        this.m_dirty = true;
    }

    public void setFloat(String name, float value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Float(value));
        this.m_dirty = true;
    }

    public void setInt(String name, int value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Integer(value));
        this.m_dirty = true;
    }

    public void setLong(String name, long value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, new Long(value));
        this.m_dirty = true;
    }

    public void setString(String name, String value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        this.getMap().put(name, value);
        this.m_dirty = true;
    }

    public void setObject(String name, Object value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        if (value == null || value instanceof Integer || value instanceof Character || value instanceof Long || value instanceof Float || value instanceof Short || value instanceof Byte || value instanceof Double || value instanceof String || value instanceof byte[] || value instanceof Boolean) {
            this.getMap().put(name, value);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        this.m_dirty = true;
    }

    public void setBytes(String name, byte[] value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        byte[] newValue = null;
        if (value != null) {
            newValue = new byte[value.length];
            System.arraycopy(value, 0, newValue, 0, value.length);
        }
        this.getMap().put(name, newValue);
        this.m_dirty = true;
    }

    public void setBytes(String name, byte[] value, int offset, int length) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkMapName(name);
        byte[] newValue = new byte[length];
        System.arraycopy(value, offset, newValue, 0, length);
        this.getMap().put(name, newValue);
        this.m_dirty = true;
    }

    private void checkMapName(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Illegal attempt to set null or empty name in MapMessage.");
        }
    }

    public boolean getBoolean(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        boolean value = false;
        if (obj instanceof Boolean) {
            value = (Boolean)obj;
        } else if (obj == null || obj instanceof String) {
            value = Boolean.valueOf((String)obj);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public byte getByte(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        byte value = 0;
        if (obj instanceof Byte) {
            value = (Byte)obj;
        } else if (obj == null || obj instanceof String) {
            value = Byte.valueOf((String)obj);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public byte[] getBytes(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        byte[] value = null;
        if (obj == null) {
            value = null;
        } else if (obj instanceof byte[]) {
            byte[] data = (byte[])obj;
            value = new byte[data.length];
            System.arraycopy(data, 0, value, 0, data.length);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public char getChar(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        char value = '\u0000';
        if (obj instanceof Character) {
            value = ((Character)obj).charValue();
        } else {
            if (obj == null) {
                throw new NullPointerException("read a null value as a char");
            }
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public double getDouble(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        double value = 0.0;
        if (obj instanceof Float) {
            value = ((Float)obj).floatValue();
        } else if (obj instanceof Double) {
            value = (Double)obj;
        } else if (obj == null || obj instanceof String) {
            value = Double.valueOf((String)obj);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public float getFloat(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        float value = 0.0f;
        if (obj instanceof Float) {
            value = ((Float)obj).floatValue();
        } else if (obj == null || obj instanceof String) {
            value = Float.valueOf((String)obj).floatValue();
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public int getInt(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        int value = 0;
        if (obj instanceof Byte) {
            value = ((Byte)obj).byteValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).shortValue();
        } else if (obj instanceof Integer) {
            value = (Integer)obj;
        } else if (obj == null || obj instanceof String) {
            value = Integer.valueOf((String)obj);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public long getLong(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        long value = 0L;
        if (obj instanceof Byte) {
            value = ((Byte)obj).byteValue();
        } else if (obj instanceof Short) {
            value = ((Short)obj).shortValue();
        } else if (obj instanceof Integer) {
            value = ((Integer)obj).intValue();
        } else if (obj instanceof Long) {
            value = (Long)obj;
        } else if (obj == null || obj instanceof String) {
            value = Long.valueOf((String)obj);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public Enumeration getMapNames() throws JMSException {
        return Collections.enumeration(this.getMap().keySet());
    }

    public Object getObject(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        if (obj == null || obj instanceof Boolean || obj instanceof Byte || obj instanceof Character || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short || obj instanceof String || obj instanceof byte[]) {
            return obj;
        }
        AQjmsError.throwEx(122, "Corrupted message");
        return obj;
    }

    public short getShort(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        short value = 0;
        if (obj instanceof Byte) {
            value = ((Byte)obj).byteValue();
        } else if (obj instanceof Short) {
            value = (Short)obj;
        } else if (obj == null || obj instanceof String) {
            value = Short.valueOf((String)obj);
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public String getString(String name) throws JMSException {
        Object obj = this.getMap().get(name);
        String value = null;
        if (obj instanceof Integer || obj instanceof Character || obj instanceof Long || obj instanceof Float || obj instanceof Short || obj instanceof Byte || obj instanceof Double || obj instanceof String || obj instanceof Boolean) {
            value = obj.toString();
        } else if (obj == null || obj instanceof String) {
            value = (String)obj;
        } else {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return value;
    }

    public boolean itemExists(String name) throws JMSException {
        return this.getMap().containsKey(name);
    }

    public void clearBody() throws JMSException {
        if (this.m_map == null) {
            this.m_map = new HashMap();
        } else {
            this.m_map.clear();
        }
        this.m_dirty = true;
        this.setAccessMode(2);
    }

    protected ORAData getMessageCont(AQjmsSession sess, boolean useTemporaryLob) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getMessageCont", "entry");
        this.updateBytesDataFromMap();
        AQjmsMapMessage_C cont = new AQjmsMapMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 3, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getMessageCont", "exit");
        return cont;
    }

    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getGenMessageCont", "entry");
        this.updateBytesDataFromMap();
        AQjmsGenMessage_C cont = new AQjmsGenMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 3, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.getGenMessageCont", "exit");
        return cont;
    }

    void writeLob(AQjmsSession sess, String queueTable, byte[] msgid, boolean isAnydataDest) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, sess, queueTable, msgid, isAnydataDest);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapmessage.writeLob", "exit");
    }

    private void readMapMessageContainer(AQjmsMapMessage_C msgCont) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C msgCont) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void updateBytesDataFromMap() throws JMSException {
        if (this.m_dirty) {
            this.m_bytesData = AQjmsMapMessage.convertHashMapToByteArray(this.m_map);
            this.m_dirty = false;
        }
    }

    private Map getMap() throws JMSException {
        if (this.m_map == null) {
            this.m_map = AQjmsMapMessage.convertByteArrayToHashMap(this.m_bytesData);
        }
        return this.m_map;
    }

    private static byte[] convertHashMapToByteArray(HashMap map) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashMapToByteArray", "entry");
        try {
            ByteArrayOutputStream baostream = new ByteArrayOutputStream();
            ObjectOutputStream oostream = new ObjectOutputStream(baostream);
            oostream.writeObject(map);
            AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertHashMapToByteArray", "exit");
            return baostream.toByteArray();
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertHashMapToByteArray IO", io_exp);
            AQjmsError.throwEx(157, (Throwable)io_exp);
            return null;
        }
    }

    private static HashMap convertByteArrayToHashMap(byte[] in_byte_array) throws JMSException {
        HashMap hashMap = null;
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashMap", "entry");
        if (in_byte_array == null) {
            in_byte_array = new byte[]{};
        }
        try {
            ByteArrayInputStream baistream = new ByteArrayInputStream(in_byte_array);
            ObjectInputStream oistream = new ObjectInputStream(baistream);
            Object mapObject = oistream.readObject();
            hashMap = mapObject instanceof Hashtable ? new HashMap((Map)mapObject) : (HashMap)mapObject;
        }
        catch (ClassNotFoundException cnf_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashMap CNF", cnf_exp);
            AQjmsError.throwEx(109, (Throwable)cnf_exp);
            return null;
        }
        catch (InvalidClassException ic_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashMap ICE", ic_exp);
            AQjmsError.throwEx(156, (Throwable)ic_exp);
        }
        catch (IOException io_exp) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMapMessage.convertByteArrayToHashMap IO", io_exp);
            AQjmsError.throwEx(157, (Throwable)io_exp);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMapMessage.convertByteArrayToHashMap", "exit");
        return hashMap;
    }
}

