/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ObjectFactory;
import oracle.AQ.AQException;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsOracleDebug;

public class AQjmsDestinationFactory
implements ObjectFactory {
    private int type = 10;
    private String owner;
    private String qname;
    private String table;
    private int payload_type;
    private String p_data_type = null;
    private AQjmsDestinationProperty property = null;
    private String tabledn;
    static final String QTYPE_ATTR = "queuetype";
    static final String RETRY_ATTR = "maxretries";
    static final String INTVL_ATTR = "retryinterval";
    static final String RETEN_ATTR = "rentention";
    static final String PLTYP_ATTR = "payloadtype";
    static final String MUCSM_ATTR = "multiconsumers";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws JMSException {
        Reference ref = (Reference)obj;
        AQjmsOracleDebug.trace(4, "AQjmsDestinationFactory.getObjectInstance", "entry");
        if (ref == null) {
            AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "Reference object is null");
            return null;
        }
        if (!ref.getClassName().equals("oracle.jms.AQjmsDestination")) {
            AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "unable to manufacture object of class: " + ref.getClassName());
            return null;
        }
        try {
            SearchControls constraints = new SearchControls();
            constraints.setSearchScope(0);
            NamingEnumeration<SearchResult> results = ((DirContext)nameCtx).search(name, "(objectclass=*)", constraints);
            if (results == null) {
                AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "failed to search attributes of queue " + name.get(0));
                return null;
            }
            SearchResult si = results.next();
            Attributes attrs = si.getAttributes();
            this.owner = (String)attrs.get("orclDBAQObjOwner").get();
            this.qname = (String)attrs.get("orclDBAQObjName").get();
            this.tabledn = (String)attrs.get("orclDBAQPointerAttr").get();
            this.property = new AQjmsDestinationProperty();
            Attribute gen_attr = attrs.get("orclDBAQGeneric");
            for (int i = 0; i < gen_attr.size(); ++i) {
                Double dbval;
                Integer intval;
                String val = (String)gen_attr.get(i);
                if (val.toLowerCase().startsWith(QTYPE_ATTR)) {
                    intval = Integer.valueOf(val.substring(QTYPE_ATTR.length() + 1));
                    try {
                        this.property.setQueueType(intval);
                    }
                    catch (AQException aq_ex) {
                        AQjmsError.throwEx(155, (Throwable)aq_ex);
                    }
                    continue;
                }
                if (val.toLowerCase().startsWith(RETRY_ATTR)) {
                    intval = Integer.valueOf(val.substring(RETRY_ATTR.length() + 1));
                    this.property.setMaxRetries((int)intval);
                    continue;
                }
                if (val.toLowerCase().startsWith(INTVL_ATTR)) {
                    dbval = Double.valueOf(val.substring(INTVL_ATTR.length() + 1));
                    this.property.setRetryInterval((double)dbval);
                    continue;
                }
                if (!val.toLowerCase().startsWith(RETEN_ATTR)) continue;
                dbval = Double.valueOf(val.substring(RETEN_ATTR.length() + 1));
                this.property.setRetentionTime((double)dbval);
            }
            InitialDirContext ctx = new InitialDirContext(environment);
            String[] attrstoret = new String[]{"orclDBAQObjOwner", "orclDBAQObjName", "orclDBAQGeneric"};
            constraints.setReturningAttributes(attrstoret);
            results = ctx.search(this.tabledn, "(objectclass=*)", constraints);
            if (results == null) {
                AQjmsOracleDebug.trace(3, "AQjmsDestinationFactory.getObjectInstance", "failed to search attributes of queue table " + this.tabledn);
                return null;
            }
            si = results.next();
            attrs = si.getAttributes();
            gen_attr = attrs.get("orclDBAQGeneric");
            this.table = (String)attrs.get("orclDBAQObjName").get();
            for (int i = 0; i < gen_attr.size(); ++i) {
                String strval;
                String val = (String)gen_attr.get(i);
                if (val.toLowerCase().startsWith(PLTYP_ATTR)) {
                    strval = val.substring(PLTYP_ATTR.length() + 1);
                    if (strval.toLowerCase().equals("raw")) {
                        this.p_data_type = null;
                        this.payload_type = 2;
                        continue;
                    }
                    this.p_data_type = new String(strval);
                    this.payload_type = 1;
                    continue;
                }
                if (!val.toLowerCase().startsWith(MUCSM_ATTR)) continue;
                strval = val.substring(MUCSM_ATTR.length() + 1);
                this.type = strval.toLowerCase().equals("true") ? 20 : 10;
            }
            AQjmsDestination dest = new AQjmsDestination(this.owner, this.qname, this.type, this.payload_type, this.p_data_type, this.property, this.table, false);
            AQjmsOracleDebug.trace(4, "AQjmsDestinationFactory.getObjectInstance", "exit");
            return dest;
        }
        catch (NamingException e) {
            AQjmsOracleDebug.traceEx(3, "AQjmsDestinationFactory.getObjectInstance", e);
            AQjmsError.throwEx(205, (Throwable)e);
            return null;
        }
    }
}

