/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jms.plsql.InternalException;
import oracle.jms.plsql.ResourceMgr;
import oracle.jms.plsql.TypeConversionException;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

class TypeConversion {
    private static ArrayDescriptor adNameArray = null;
    private static StructDescriptor sdJmsValue = null;
    private static Object[] nullAttribs = new Object[]{null, null, null, null, null};

    TypeConversion() {
    }

    private static StructDescriptor getJmsValueSD() throws SQLException {
        if (sdJmsValue == null) {
            sdJmsValue = StructDescriptor.createDescriptor((String)"SYS.AQ$_JMS_VALUE", (Connection)ResourceMgr.getConnection());
        }
        return sdJmsValue;
    }

    private static ArrayDescriptor getNameArrayAD() throws SQLException {
        if (adNameArray == null) {
            adNameArray = ArrayDescriptor.createDescriptor((String)"SYS.AQ$_JMS_NAMEARRAY", (Connection)ResourceMgr.getConnection());
        }
        return adNameArray;
    }

    static Object jmsConvert(Object srcObj, int destType) throws TypeConversionException {
        try {
            switch (destType) {
                case 0: {
                    if (srcObj instanceof Byte) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Byte.valueOf((String)srcObj);
                    }
                    throw new TypeConversionException();
                }
                case 1: {
                    if (srcObj instanceof Short) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Short.valueOf((String)srcObj);
                    }
                    if (srcObj instanceof Byte) {
                        return new Short(((Byte)srcObj).shortValue());
                    }
                    throw new TypeConversionException();
                }
                case 2: {
                    if (srcObj instanceof Integer) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Integer.valueOf((String)srcObj);
                    }
                    if (srcObj instanceof Byte) {
                        return new Integer(((Byte)srcObj).intValue());
                    }
                    if (srcObj instanceof Short) {
                        return new Integer(((Short)srcObj).intValue());
                    }
                    throw new TypeConversionException();
                }
                case 3: {
                    if (srcObj instanceof Long) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Long.valueOf((String)srcObj);
                    }
                    if (srcObj instanceof Byte) {
                        return new Long(((Byte)srcObj).longValue());
                    }
                    if (srcObj instanceof Short) {
                        return new Long(((Short)srcObj).longValue());
                    }
                    if (srcObj instanceof Integer) {
                        return new Long(((Integer)srcObj).longValue());
                    }
                    throw new TypeConversionException();
                }
                case 4: {
                    if (srcObj instanceof Float) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Float.valueOf((String)srcObj);
                    }
                    throw new TypeConversionException();
                }
                case 5: {
                    if (srcObj instanceof Double) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Double.valueOf((String)srcObj);
                    }
                    if (srcObj instanceof Float) {
                        return new Double(((Float)srcObj).doubleValue());
                    }
                    throw new TypeConversionException();
                }
                case 6: {
                    if (srcObj instanceof Boolean) {
                        return srcObj;
                    }
                    if (srcObj instanceof String) {
                        return Boolean.valueOf((String)srcObj);
                    }
                    throw new TypeConversionException();
                }
                case 7: {
                    if (srcObj instanceof Character) {
                        return srcObj;
                    }
                    throw new TypeConversionException();
                }
                case 8: {
                    if (srcObj instanceof String) {
                        return srcObj;
                    }
                    if (srcObj instanceof Boolean || srcObj instanceof Byte || srcObj instanceof Short || srcObj instanceof Character || srcObj instanceof Integer || srcObj instanceof Long || srcObj instanceof Float || srcObj instanceof Double) {
                        return srcObj.toString();
                    }
                    throw new TypeConversionException();
                }
                case 9: {
                    if (srcObj instanceof byte[]) {
                        return srcObj;
                    }
                    throw new TypeConversionException();
                }
            }
            throw new TypeConversionException();
        }
        catch (NumberFormatException nfe) {
            throw new TypeConversionException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void objToJmsValue(Object objValue, STRUCT[] value, int[] nullInd) throws TypeConversionException, SQLException {
        Object[] attribs = new Object[]{null, null, null, null, null};
        if (objValue != null) {
            nullInd[0] = 0;
            if (objValue instanceof Byte) {
                attribs[0] = new NUMBER(0);
                attribs[1] = new NUMBER(((Byte)objValue).byteValue());
            } else if (objValue instanceof Short) {
                attribs[0] = new NUMBER(1);
                attribs[1] = new NUMBER(((Short)objValue).shortValue());
            } else if (objValue instanceof Integer) {
                attribs[0] = new NUMBER(2);
                attribs[1] = new NUMBER(((Integer)objValue).intValue());
            } else if (objValue instanceof Long) {
                attribs[0] = new NUMBER(3);
                attribs[1] = new NUMBER(((Long)objValue).longValue());
            } else if (objValue instanceof Float) {
                attribs[0] = new NUMBER(4);
                attribs[1] = new NUMBER(((Float)objValue).floatValue());
            } else if (objValue instanceof Double) {
                attribs[0] = new NUMBER(5);
                attribs[1] = new NUMBER(((Double)objValue).doubleValue());
            } else if (objValue instanceof Boolean) {
                attribs[0] = new NUMBER(6);
                attribs[1] = new NUMBER(((Boolean)objValue).booleanValue());
            } else if (objValue instanceof Character) {
                attribs[0] = new NUMBER(7);
                attribs[2] = ((Character)objValue).toString();
            } else if (objValue instanceof String) {
                attribs[0] = new NUMBER(8);
                CLOB clob = ResourceMgr.getSharedClob();
                clob.putString(1L, (String)objValue);
                attribs[3] = clob;
            } else {
                if (!(objValue instanceof byte[])) throw new TypeConversionException();
                attribs[0] = new NUMBER(9);
                BLOB blob = ResourceMgr.getSharedBlob();
                blob.putBytes(1L, (byte[])objValue);
                attribs[4] = blob;
            }
        } else {
            nullInd[0] = 1;
        }
        value[0] = new STRUCT(TypeConversion.getJmsValueSD(), ResourceMgr.getConnection(), attribs);
    }

    static STRUCT getNullSTRUCT() throws SQLException {
        return new STRUCT(TypeConversion.getJmsValueSD(), ResourceMgr.getConnection(), nullAttribs);
    }

    static ARRAY arrayToARRAY(String[] names) throws SQLException {
        return new ARRAY(TypeConversion.getNameArrayAD(), ResourceMgr.getConnection(), (Object)names);
    }

    static ARRAY getNullARRAY() throws SQLException {
        return new ARRAY(TypeConversion.getNameArrayAD(), ResourceMgr.getConnection(), (Object)new String[0]);
    }

    static NUMBER objToNumber(Object objValue, int type) throws InternalException, SQLException {
        if (objValue == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return new NUMBER(((Byte)objValue).byteValue());
            }
            case 1: {
                return new NUMBER(((Short)objValue).shortValue());
            }
            case 2: {
                return new NUMBER(((Integer)objValue).intValue());
            }
            case 3: {
                return new NUMBER(((Long)objValue).longValue());
            }
            case 4: {
                return new NUMBER(((Float)objValue).floatValue());
            }
            case 5: {
                return new NUMBER(((Double)objValue).doubleValue());
            }
            case 6: {
                return new NUMBER(((Boolean)objValue).booleanValue());
            }
        }
        throw new InternalException();
    }

    static Object numberToObj(NUMBER value, int type) throws InternalException, SQLException {
        switch (type) {
            case 0: {
                return new Byte(value.byteValue());
            }
            case 1: {
                return new Short(value.shortValue());
            }
            case 2: {
                return new Integer(value.intValue());
            }
            case 3: {
                return new Long(value.longValue());
            }
            case 4: {
                return new Float(value.floatValue());
            }
            case 5: {
                return new Double(value.doubleValue());
            }
            case 6: {
                return new Boolean(value.booleanValue());
            }
        }
        throw new InternalException();
    }
}

