/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsXASession;

public class AQjmsXAResource
implements XAResource {
    private XAResource m_jdbcXAResource;
    private AQjmsXASession m_jmsXASession;

    AQjmsXAResource(AQjmsXASession jmsXASession, XAResource jdbcXAResource) {
        this.m_jdbcXAResource = jdbcXAResource;
        this.m_jmsXASession = jmsXASession;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.commit", "enter: XAResource=" + this + ", xid=" + xid + ",  onePhase=" + onePhase);
        this.checkConsistency();
        try {
            this.m_jdbcXAResource.commit(xid, onePhase);
            if (!AQjmsConstants.ignorePriority()) {
                this.m_jmsXASession.restartConsumers();
            }
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.commit", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.commit", "exit");
    }

    public void end(Xid xid, int flags) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.end", "enter: XAResource=" + this + ", xid=" + xid + ", flags=" + flags);
        try {
            this.m_jdbcXAResource.end(xid, flags);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.end", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.end", "exit");
    }

    public void forget(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.forget", "enter: XAResource=" + this + ", xid=" + xid);
        try {
            this.m_jdbcXAResource.forget(xid);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.forget", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.forget", "exit");
    }

    public int getTransactionTimeout() throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.getTransactionTimeout", "enter");
        int timeout = 0;
        try {
            timeout = this.m_jdbcXAResource.getTransactionTimeout();
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.getTransactionTimeout", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.getTransactionTimeout", "exit");
        return timeout;
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.isSameRM", "enter: my XAResource=" + this + ", target XAResource=" + xares);
        boolean isSame = false;
        try {
            isSame = xares == null ? false : (this == xares ? true : (xares instanceof AQjmsXAResource ? this.m_jdbcXAResource.isSameRM(((AQjmsXAResource)xares).getWrappedXARes()) : this.m_jdbcXAResource.isSameRM(xares)));
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.isSameRM", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.isSameRM", "exit");
        return isSame;
    }

    public int prepare(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.prepare", "enter: XAResource=" + this + ", xid=" + xid);
        this.checkConsistency();
        int result = 0;
        try {
            result = this.m_jdbcXAResource.prepare(xid);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.prepare", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.prepare", "exit");
        return result;
    }

    public Xid[] recover(int flag) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.recover", "enter: XAResource=" + this + ", flag=" + flag);
        Xid[] xidList = null;
        try {
            xidList = this.m_jdbcXAResource.recover(flag);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.recover", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.recover", "exit");
        return xidList;
    }

    public void rollback(Xid xid) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.rollback", "enter: XAResource=" + this + ", xid=" + xid);
        try {
            this.m_jdbcXAResource.rollback(xid);
            this.m_jmsXASession.setConsistency(true);
            this.m_jmsXASession.restartConsumers();
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.rollback", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.rollback", "exit");
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.setTransactionTimeout", "enter: XAResource=" + this + ", seconds=" + seconds);
        boolean result = false;
        try {
            result = this.m_jdbcXAResource.setTransactionTimeout(seconds);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.setTransactionTimeout", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.setTransactionTimeout", "exit");
        return result;
    }

    public void start(Xid xid, int flags) throws XAException {
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.start", "enter: XAResource=" + this + ", xid=" + xid + ", flags=" + flags);
        try {
            this.m_jdbcXAResource.start(xid, flags);
        }
        catch (XAException xae) {
            AQjmsOracleDebug.traceEx(1, "AQjmsXAResource.start", xae);
            throw xae;
        }
        AQjmsOracleDebug.trace(1, "AQjmsXAResource.start", "exit");
    }

    XAResource getWrappedXARes() {
        return this.m_jdbcXAResource;
    }

    private void checkConsistency() throws XAException {
        try {
            this.m_jmsXASession.checkConsistency();
        }
        catch (JMSException e) {
            throw new XAException("cannot commit the JMS session that is in inconsistent state");
        }
    }
}

