/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.UTFDataFormatException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;
import oracle.i18n.text.OraCharsetDecoder;
import oracle.i18n.text.OraCharsetEncoder;

class OraCharsetUTFE
extends OraCharset {
    static final int MAXBYTEPERCHAR = 4;
    static byte[][] utf8m2utfe = new byte[][]{{0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15}, {16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31}, {64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97}, {-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111}, {124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42}, {-41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109}, {121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106}, {-105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7}, {32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27}, {48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1}, {65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 81, 82, 83, 84, 85, 86}, {87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115}, {116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100}, {-99, -98, -97, -96, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -75, -74}, {-73, -72, -71, -70, -69, -68, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37}, {-36, -35, -34, -33, -31, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2}};
    static byte[][] utfe2utf8m = new byte[][]{{0, 1, 2, 3, -100, 9, -122, 127, -105, -115, -114, 11, 12, 13, 14, 15}, {16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31}, {-128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7}, {-112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26}, {32, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, 46, 60, 40, 43, 124}, {38, -86, -85, -84, -83, -82, -81, -80, -79, -78, 33, 36, 42, 41, 59, 94}, {45, 47, -77, -76, -75, -74, -73, -72, -71, -70, -69, 44, 37, 95, 62, 63}, {-68, -67, -66, -65, -64, -63, -62, -61, -60, 96, 58, 35, 64, 39, 61, 34}, {-59, 97, 98, 99, 100, 101, 102, 103, 104, 105, -58, -57, -56, -55, -54, -53}, {-52, 106, 107, 108, 109, 110, 111, 112, 113, 114, -51, -50, -49, -48, -47, -46}, {-45, 126, 115, 116, 117, 118, 119, 120, 121, 122, -44, -43, -42, 88, -41, -40}, {-39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, 93, -26, -25}, {123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, -22, -21, -20, -19}, {13, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, -16, -15, -14, -13}, {92, -12, 83, 84, 85, 86, 87, 88, 89, 90, -11, -10, -9, -8, -7, -6}, {48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -5, -4, -3, -2, -1, -97}};

    OraCharsetUTFE(String string, int n) {
        super(string, n);
    }

    public boolean contains(Charset charset) {
        return true;
    }

    public CharsetDecoder newDecoder() {
        return new OraCharsetDecoder(this, 1.0f, 1.0f);
    }

    public CharsetEncoder newEncoder() {
        return new OraCharsetEncoder(this, 1.0f, 3.0f);
    }

    String toString(byte[] byArray, int n, int n2) throws SQLException {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = this.UTFEToJavaChar(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPORT_ERROR);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new SQLException(uTFDataFormatException.getMessage());
        }
    }

    String toStringWithReplacement(byte[] byArray, int n, int n2) {
        try {
            char[] cArray = new char[byArray.length];
            int n3 = this.UTFEToJavaChar(byArray, n, n2, cArray, OraCharset.CharacterConverterBehavior.REPLACEMENT);
            return new String(cArray, 0, n3);
        }
        catch (UTFDataFormatException uTFDataFormatException) {
            throw new IllegalStateException(uTFDataFormatException.getMessage());
        }
    }

    int UTFEToJavaChar(byte[] byArray, int n, int n2, char[] cArray, OraCharset.CharacterConverterBehavior characterConverterBehavior) throws UTFDataFormatException {
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        block7: while (n3 < n4) {
            byte by = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
            switch (by >>> 4 & 0xF) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n5++] = (char)(by & 0x7F);
                    continue block7;
                }
                case 8: 
                case 9: {
                    cArray[n5++] = (char)(by & 0x1F);
                    continue block7;
                }
                case 12: 
                case 13: {
                    if (n3 >= n4) {
                        characterConverterBehavior.onFailConversion();
                        n3 = n4;
                        continue block7;
                    }
                    by = (byte)(by & 0x1F);
                    byte by2 = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
                    if (!OraCharsetUTFE.is101xxxxx(by2)) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n5++] = 65533;
                        continue block7;
                    }
                    cArray[n5++] = (char)(by << 5 | by2 & 0x1F);
                    continue block7;
                }
                case 14: {
                    if (n3 + 1 >= n4) {
                        characterConverterBehavior.onFailConversion();
                        n3 = n4;
                        continue block7;
                    }
                    by = (byte)(by & 0xF);
                    byte by2 = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
                    byte by3 = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
                    if (!OraCharsetUTFE.is101xxxxx(by2) || !OraCharsetUTFE.is101xxxxx(by3)) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n5++] = 65533;
                        continue block7;
                    }
                    cArray[n5++] = (char)(by << 10 | (by2 & 0x1F) << 5 | by3 & 0x1F);
                    continue block7;
                }
                case 15: {
                    if (n3 + 2 >= n4) {
                        characterConverterBehavior.onFailConversion();
                        n3 = n4;
                        continue block7;
                    }
                    by = (byte)(by & 1);
                    byte by2 = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
                    byte by3 = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
                    byte by4 = utfe2utf8m[OraCharsetUTFE.high(byArray[n3])][OraCharsetUTFE.low(byArray[n3++])];
                    if (!(OraCharsetUTFE.is101xxxxx(by2) && OraCharsetUTFE.is101xxxxx(by3) && OraCharsetUTFE.is101xxxxx(by4))) {
                        characterConverterBehavior.onFailConversion();
                        cArray[n5++] = 65533;
                        continue block7;
                    }
                    cArray[n5++] = (char)(by << 15 | (by2 & 0x1F) << 10 | (by3 & 0x1F) << 5 | by4 & 0x1F);
                    continue block7;
                }
            }
            characterConverterBehavior.onFailConversion();
            cArray[n5++] = 65533;
        }
        return n5;
    }

    byte[] convertWithReplacement(String string) {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length * 4];
        int n = this.javaCharsToUTFE(cArray, 0, cArray.length, byArray, 0);
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    byte[] convert(String string) throws SQLException {
        return this.convertWithReplacement(string);
    }

    int javaCharsToUTFE(char[] cArray, int n, int n2, byte[] byArray, int n3) {
        int n4 = n + n2;
        int n5 = 0;
        for (int i = n; i < n4; ++i) {
            int n6;
            char c = cArray[i];
            if (c <= '\u001f') {
                n6 = c | 0x80;
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
                continue;
            }
            if (c <= '\u007f') {
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(c)][OraCharsetUTFE.low(c)];
                continue;
            }
            if (c <= '\u03ff') {
                n6 = (c & 0x3E0) >> 5 | 0xC0;
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
                n6 = c & 0x1F | 0xA0;
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
                continue;
            }
            if (c <= '\u3fff') {
                n6 = (c & 0x3C00) >> 10 | 0xE0;
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
                n6 = (c & 0x3E0) >> 5 | 0xA0;
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
                n6 = c & 0x1F | 0xA0;
                byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
                continue;
            }
            n6 = (c & 0x8000) >> 15 | 0xF0;
            byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
            n6 = (c & 0x7C00) >> 10 | 0xA0;
            byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
            n6 = (c & 0x3E0) >> 5 | 0xA0;
            byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
            n6 = c & 0x1F | 0xA0;
            byArray[n5++] = utf8m2utfe[OraCharsetUTFE.high(n6)][OraCharsetUTFE.low(n6)];
        }
        return n5;
    }

    private static int high(int n) {
        return n >>> 4 & 0xF;
    }

    private static int low(int n) {
        return n & 0xF;
    }

    private static boolean is101xxxxx(byte by) {
        return (by & 0xFFFFFFE0) == -96;
    }
}

