/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text.converter;

import java.sql.SQLException;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.text.converter.GDKMessage;
import oracle.i18n.util.GDKOracleMetaData;

public class CharacterConverter2ByteFixed
extends CharacterConverter12Byte {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();

    public CharacterConverter2ByteFixed() {
        this.m_groupId = 6;
        this.averageCharsPerByte = 0.5f;
        this.maxCharsPerByte = 1.0f;
        this.maxBytesPerChar = 2.0f;
    }

    public String toUnicodeString(byte[] byArray, int n, int n2) throws SQLException {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = 0;
        for (int i = n; i < n3; ++i) {
            int n5 = byArray[i] & 0xFF;
            if (i < n3 - 1) {
                n5 = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
                ++i;
            } else {
                throw new SQLException(GDKMessage.getORAMessage(17154), null, 17154);
            }
            int n6 = this.toUnicode(n5);
            if (((long)n6 & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n6 >>> 16);
                cArray[n4++] = (char)(n6 & 0xFFFF);
                continue;
            }
            cArray[n4++] = (char)n6;
        }
        return new String(cArray, 0, n4);
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        char[] cArray = new char[n2];
        int n4 = 0;
        int n5 = 0;
        for (int i = n; i < n3; ++i) {
            int n6;
            n5 = byArray[i] & 0xFF;
            if (i < n3 - 1) {
                n5 = byArray[i] << 8 & 0xFF00 | byArray[i + 1] & 0xFF;
                ++i;
            }
            if (((long)(n6 = this.toUnicodeWithReplacement(n5)) & 0xFFFFFFFFL) > 65535L) {
                cArray[n4++] = (char)(n6 >>> 16);
                cArray[n4++] = (char)(n6 & 0xFFFF);
                continue;
            }
            cArray[n4++] = (char)n6;
        }
        return new String(cArray, 0, n4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c;
            if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                if (i + 1 >= n || cArray[i + 1] < '\udc00' || cArray[i + 1] > '\udfff') throw new SQLException(GDKMessage.getORAMessage(17155), null, 17155);
                c = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                ++i;
            } else {
                c = this.toOracleCharacter(cArray[i], '\u0000');
            }
            byArray[n2++] = (byte)(c >> 8);
            byArray[n2++] = (byte)c;
        }
        if (n2 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte[] toOracleStringWithReplacement(String string) {
        int n = string.length();
        if (n == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n * 2];
        int n2 = 65535;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            block6: {
                if (cArray[i] >= '\ud800' && cArray[i] < '\udc00') {
                    if (i + 1 < n && cArray[i + 1] >= '\udc00' && cArray[i + 1] <= '\udfff') {
                        n2 = this.toOracleCharacterWithReplacement(cArray[i], cArray[i + 1]);
                        ++i;
                        break block6;
                    } else {
                        byArray[n3++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n3++] = (byte)this.m_2ByteOraCharReplacement;
                        continue;
                    }
                }
                n2 = this.toOracleCharacterWithReplacement(cArray[i], '\u0000');
            }
            byArray[n3++] = (byte)(n2 >> 8);
            byArray[n3++] = (byte)n2;
        }
        if (n3 < byArray.length) {
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, n3);
            return byArray2;
        }
        return byArray;
    }
}

