/*
 * Decompiled with CFR 0.152.
 */
package oracle.AQ;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.Reference;
import javax.naming.Referenceable;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleDebug;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleSQLException;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueue;
import oracle.AQ.AQQueueProperty;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.AQ.AQSession;
import oracle.AQ.AQUtil;
import oracle.jdbc.OracleCallableStatement;

public class AQOracleQueueTable
implements AQQueueTable,
Referenceable {
    private String owner;
    private String name;
    AQQueueTableProperty property;
    boolean multi_consumer;
    private AQOracleSession aq_sess;
    private CallableStatement crtq_stmt;
    private CallableStatement alqt_stmt;
    private CallableStatement allqt_stmt;
    private CallableStatement allqto_stmt;

    AQOracleQueueTable(AQOracleSession conn, String qt_owner, String qt_name, AQQueueTableProperty qt_prop) throws AQException {
        this.owner = qt_owner;
        if (qt_name == null || qt_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, qt_name);
        }
        this.name = qt_name;
        this.property = qt_prop;
        this.aq_sess = conn;
        this.multi_consumer = qt_prop.isMulticonsumerEnabled();
    }

    public String getOwner() throws AQException {
        return this.owner;
    }

    void setOwner(String qt_owner) throws AQException {
        this.owner = qt_owner;
    }

    public String getName() throws AQException {
        return this.name;
    }

    void setName(String qt_name) throws AQException {
        if (qt_name == null || qt_name.equals("")) {
            AQUtil.throwAQEx(179, "");
        }
        if (qt_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(179, qt_name);
        }
        this.name = qt_name;
    }

    public AQSession getAQSession() {
        return this.aq_sess;
    }

    private void setAQSession(AQOracleSession sess) throws AQException {
        if (sess != null) {
            this.aq_sess = sess;
        } else {
            AQUtil.throwAQEx(194);
        }
    }

    public AQQueueTableProperty getProperty() throws AQException {
        Object qt_property = null;
        Connection db_conn = null;
        ResultSet rset = null;
        String pload_type = null;
        boolean found_table = false;
        String qt_owner = null;
        String sec_flag = null;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(188);
            }
            if (this.owner != null && !this.owner.equals("")) {
                qt_owner = this.owner;
            }
            if (qt_owner != null) {
                try {
                    if (this.allqto_stmt == null) {
                        this.allqto_stmt = this.aq_sess.is92compatible() ? db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where owner = ? and queue_table = ?") : db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where owner = ? and queue_table = ?");
                    } else {
                        this.allqto_stmt.clearParameters();
                    }
                    this.allqto_stmt.setString(1, qt_owner.toUpperCase());
                    this.allqto_stmt.setString(2, this.name.toUpperCase());
                    rset = this.allqto_stmt.executeQuery();
                }
                catch (SQLException sqlex) {
                    AQOracleDebug.traceEx(3, "AQOracleQueueTable.getProperty-1", sqlex);
                    try {
                        this.allqto_stmt.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.allqto_stmt = null;
                    throw sqlex;
                }
            }
            try {
                if (qt_owner == null) {
                    this.allqt_stmt = this.aq_sess.is92compatible() ? db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner, secure from all_queue_tables where queue_table = ?") : db_conn.prepareCall("select queue_table, type, object_type, sort_order, recipients, message_grouping, user_comment, compatible, primary_instance, secondary_instance, owner from all_queue_tables where queue_table = ?");
                    this.allqt_stmt.setString(1, this.name.toUpperCase());
                    rset = this.allqt_stmt.executeQuery();
                }
            }
            catch (SQLException sqlex) {
                try {
                    this.allqt_stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.allqt_stmt = null;
                AQOracleDebug.traceEx(3, "AQOracleQueueTable.getProperty-2", sqlex);
                throw sqlex;
            }
            if (rset != null && rset.next()) {
                pload_type = rset.getString(2);
                if (pload_type.equals("RAW")) {
                    this.property = new AQQueueTableProperty("RAW");
                } else {
                    pload_type = rset.getString(3);
                    this.property = new AQQueueTableProperty(pload_type);
                }
                this.property.setSortOrder(rset.getString(4));
                if (rset.getString(5).equals("SINGLE")) {
                    this.property.setMultiConsumer(false);
                } else {
                    this.property.setMultiConsumer(true);
                }
                if (rset.getString(6).equals("TRANSACTIONAL")) {
                    this.property.setMessageGrouping(1);
                }
                if (rset.getString(7) != null) {
                    this.property.setComment(rset.getString(7));
                }
                this.property.setCompatible(rset.getString(8));
                this.property.setPrimaryInstance(rset.getInt(9));
                this.property.setSecondaryInstance(rset.getInt(10));
                if (this.aq_sess.is92compatible()) {
                    sec_flag = rset.getString(12);
                    AQOracleDebug.trace(5, "AQOracleQueueTable.getProperty", "Secure queue table: " + sec_flag);
                    if (sec_flag.equalsIgnoreCase("YES")) {
                        this.property.setSecure(true);
                    }
                }
            } else if (qt_owner != null) {
                AQUtil.throwAQEx(173, qt_owner + "." + this.name);
            } else {
                AQUtil.throwAQEx(173, this.name);
            }
            if (rset.next()) {
                if (qt_owner != null) {
                    AQUtil.throwAQEx(172, "");
                } else {
                    AQUtil.throwAQEx(172, "(must specify owner)");
                }
            }
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception nex) {}
        }
        catch (SQLException sqlex) {
            try {
                if (rset != null) {
                    rset.close();
                }
            }
            catch (Exception nex) {
                // empty catch block
            }
            AQOracleDebug.traceEx(3, "AQOracleQeueueTable.getProperty-3", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        return this.property;
    }

    public AQQueueTableProperty getProperty(boolean cached) throws AQException {
        if (cached) {
            AQOracleDebug.trace(5, "AQOracleQueueTable.getProperty", "return cached prop");
            return this.property;
        }
        AQOracleDebug.trace(5, "AQOracleQueueTable.getProperty", "get prop from db");
        return this.getProperty();
    }

    void setProperty(AQQueueTableProperty qt_prop) throws AQException {
        this.property = qt_prop;
    }

    public void alter(String comment, int primary_instance, int secondary_instance) throws AQException {
        Connection db_conn = null;
        String table_name = "";
        boolean ret_status = false;
        String force_flag = "false";
        String ac_flag = "true";
        table_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(188);
            }
            if (this.alqt_stmt != null) {
                this.alqt_stmt.clearParameters();
            } else {
                this.alqt_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_queue_table(queue_table => ?, comment => ?, primary_instance => ?, secondary_instance => ?); end;");
            }
            this.alqt_stmt.setString(1, table_name);
            this.alqt_stmt.setString(2, comment);
            this.alqt_stmt.setInt(3, primary_instance);
            this.alqt_stmt.setInt(4, secondary_instance);
            ((OracleCallableStatement)this.alqt_stmt).executeQuery();
            this.property.setComment(comment);
            if (primary_instance != 0) {
                this.property.setPrimaryInstance(primary_instance);
            }
            if (secondary_instance != 0) {
                this.property.setSecondaryInstance(secondary_instance);
            }
        }
        catch (SQLException sqlex) {
            try {
                this.alqt_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.alqt_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueueTable.alter", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
    }

    public void alter(String comment) throws AQException {
        this.alter(comment, 0, 0);
    }

    public void drop(boolean force) throws AQException {
        Statement qt_stmt = null;
        Connection db_conn = null;
        String table_name = "";
        boolean ret_status = false;
        boolean auto_commit = true;
        String force_flag = "false";
        String ac_flag = "true";
        if (this.name == null || this.name.equals("")) {
            AQUtil.throwAQEx(188);
        }
        table_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            db_conn = this.aq_sess.getDBConnection();
        }
        catch (Exception ex) {
            AQUtil.throwAQEx(188);
        }
        try {
            if (force) {
                force_flag = "true";
            }
            if (!auto_commit) {
                ac_flag = "false";
            }
            qt_stmt = db_conn.prepareCall("begin dbms_aqadm.drop_queue_table(queue_table => ?, force => " + force_flag + ", auto_commit => " + ac_flag + "); end;");
            qt_stmt.setString(1, table_name);
            ((OracleCallableStatement)qt_stmt).executeQuery();
            try {
                qt_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueueTable.drop", sqlex);
            try {
                qt_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
        this.aq_sess = null;
    }

    public AQQueue createQueue(String queue_name, AQQueueProperty q_property) throws AQException {
        CallableStatement cq_stmt = null;
        Connection db_conn = null;
        AQOracleQueue new_queue = null;
        String table_name = "";
        String ac_flag = "true";
        if (queue_name == null || queue_name.equals("")) {
            AQUtil.throwAQEx(134);
        }
        if (q_property == null) {
            AQUtil.throwAQEx(185);
        }
        if (queue_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, queue_name);
        }
        table_name = this.owner == null || this.owner.equals("") ? this.name : this.owner + "." + this.name;
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(188);
            }
            if (!q_property.isAutoCommitEnabled()) {
                ac_flag = "false";
                cq_stmt = db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => false); end;");
            } else {
                if (this.crtq_stmt != null) {
                    this.crtq_stmt.clearParameters();
                } else {
                    this.crtq_stmt = db_conn.prepareCall("begin dbms_aqadm.create_queue(queue_name => ?, queue_table => ?, queue_type => ?, max_retries => ?, retry_delay => ?, retention_time => ?, comment => ?, auto_commit => true); end;");
                }
                cq_stmt = this.crtq_stmt;
            }
            cq_stmt.setString(1, queue_name);
            cq_stmt.setString(2, table_name);
            cq_stmt.setInt(3, q_property.getQueueType());
            if (q_property.max_retries != null) {
                ((OracleCallableStatement)cq_stmt).setObject(4, (Object)q_property.max_retries, 4);
            } else {
                ((OracleCallableStatement)cq_stmt).setNull(4, 4);
            }
            cq_stmt.setDouble(5, q_property.getRetryInterval());
            cq_stmt.setDouble(6, q_property.getRetentionTime());
            cq_stmt.setString(7, q_property.getComment());
            cq_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.crtq_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.crtq_stmt = null;
            AQOracleDebug.traceEx(3, "AQOracleQueueTable.createQueue", sqlex);
            throw new AQOracleSQLException(sqlex);
        }
        new_queue = this.property.getPayloadType().equalsIgnoreCase("RAW") ? new AQOracleQueue(this.aq_sess, this.owner, queue_name, table_name, q_property, 2, this.property.getPayloadType(), this.property.isSecure()) : new AQOracleQueue(this.aq_sess, this.owner, queue_name, table_name, q_property, 1, this.property.getPayloadType(), this.property.isSecure());
        return new_queue;
    }

    public void dropQueue(String queue_name) throws AQException {
        Statement dq_stmt = null;
        Connection db_conn = null;
        String q_name = "";
        boolean auto_commit = true;
        String ac_flag = "true";
        q_name = this.owner != null && !this.owner.equals("") ? this.owner + "." + queue_name : queue_name;
        if (queue_name.indexOf(".") != -1) {
            AQUtil.throwAQEx(178, queue_name);
        }
        try {
            try {
                db_conn = this.aq_sess.getDBConnection();
            }
            catch (Exception ex) {
                AQUtil.throwAQEx(188);
            }
            db_conn = this.aq_sess.getDBConnection();
            if (!auto_commit) {
                ac_flag = "false";
            }
            dq_stmt = db_conn.prepareCall("begin dbms_aqadm.drop_queue(queue_name => ?, auto_commit =>" + ac_flag + "); end;");
            dq_stmt.setString(1, q_name);
            dq_stmt.execute();
            try {
                dq_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            AQOracleDebug.traceEx(3, "AQOracleQueue.dropQueue", sqlex);
            try {
                dq_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQOracleSQLException(sqlex);
        }
    }

    public boolean isMulticonsumerEnabled() throws AQException {
        return this.multi_consumer;
    }

    public boolean isSecure() {
        return this.property.isSecure();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQQueueTable]");
        buf.append("\n  owner            : " + this.owner);
        buf.append("\n  name             : " + this.name);
        if (this.property != null) {
            buf.append("\n" + this.property.toString());
        }
        if (this.aq_sess != null) {
            buf.append("\n" + this.aq_sess.toString());
        }
        buf.append("\n");
        return buf.toString();
    }

    public Reference getReference() {
        Reference r = new Reference("oracle.AQ.AQOracleQueueTable", "oracle.AQ.AQOracleQueueTableFactory", null);
        return r;
    }

    public void close() {
        try {
            if (this.crtq_stmt != null) {
                this.crtq_stmt.close();
            }
            if (this.alqt_stmt != null) {
                this.alqt_stmt.close();
            }
            if (this.allqt_stmt != null) {
                this.allqt_stmt.close();
            }
            if (this.allqto_stmt != null) {
                this.allqto_stmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aq_sess = null;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

