package im.zhaojun.system.controller;

import com.github.pagehelper.PageInfo;
import im.zhaojun.common.util.PageResultBean;
import im.zhaojun.common.util.ResultBean;
import im.zhaojun.system.model.*;
import im.zhaojun.system.service.EventWriteService;
import im.zhaojun.system.service.TraffdevicewriteresultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.List;

@RestController
@RequestMapping("/traffresult")
public class TraffdevicewriteresultController {
    @Autowired
    private TraffdevicewriteresultService traffdevicewriteresultService;

    @Value("${eventsend.url}")
    String eventsendurl;

    @Value("${devicesend.url}")
    String devicesendurl;

    @Value("${devicesend.timeout}")
    private Integer timeout;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private EventWriteService eventWriteService;


    /**
     * ѯͳɹҳ
     */
    @PostMapping("/queryTraffdevicewriteresultByPage")
    public PageResultBean<Traffdevicewriteresult> queryTraffdevicewriteresultByPage(@RequestBody TraffdevicewriteresultParams traffdevicewriteresult) {

        List<Traffdevicewriteresult> list= traffdevicewriteresultService.queryTraffdevicewriteresultByPage(traffdevicewriteresult);
        PageInfo<Traffdevicewriteresult> rolePageInfo = new PageInfo<>(list);
        return new  PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }

    /**
     * ѯм״̬ҳ
     */
    @PostMapping("/querySbtdspsrResultByPage")
    public PageResultBean<SbtdspsrResult>  querySbtdspsrResultByPage(@RequestBody SbtdspsrParams sbtdspsr) {
        List<SbtdspsrResult> list=traffdevicewriteresultService.querySbtdspsrResultByPage(sbtdspsr);
        PageInfo<SbtdspsrResult> rolePageInfo = new PageInfo<>(list);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }
    /**
     * ݵƽ̨     */
    @PostMapping("/sendEvents")
    public List<ResultObj> sendEvents(@RequestBody  List<Traffalarmrecord> recordidlist){

        return eventWriteService.sendAllMessage(recordidlist);

    }

    /**
     * ݵƽ̨     */
    @PostMapping("/sendDevices")
    public List<ResultObj> sendDevices(@RequestBody  List<SbtdspsrParams> sbtdspsrlist){
        return traffdevicewriteresultService.sendDevices(sbtdspsrlist);
    }



    /**
     * 
     */
    @PostMapping("/saveTraffdevicewriteresult")
    public ResultObj saveTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        return traffdevicewriteresultService.saveTraffdevicewriteresult(traffdevicewriteresult);
    }

    /**
     * 
     */
    @PostMapping("/saveTraffdevicewriteresultList")
    public  ResultBean saveTraffdevicewriteresultList(List<Traffdevicewriteresult> traffdevicewriteresultList) {
         traffdevicewriteresultService.saveTraffdevicewriteresultList(traffdevicewriteresultList);
        return ResultBean.success();
    }

    /**
     * 
     */
    @PostMapping("/updateTraffdevicewriteresult")
    public ResultBean updateTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
         traffdevicewriteresultService.updateTraffdevicewriteresult(traffdevicewriteresult);
         return ResultBean.success();
    }

    /**
     * ɾ
     */
    @PostMapping("/deleteTraffdevicewriteresult")
    public ResultBean deleteTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        traffdevicewriteresultService.deleteTraffdevicewriteresult(traffdevicewriteresult);
        return ResultBean.success();
    }

    /**
     * ɾ
     */
    @PostMapping("/deleteTraffdevicewriteresultList")
    public ResultBean deleteTraffdevicewriteresultList(List<Traffdevicewriteresult> traffdevicewriteresultList) {
        traffdevicewriteresultService.deleteTraffdevicewriteresultList(traffdevicewriteresultList);
        return ResultBean.success();
    }

}