package im.zhaojun.system.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

public class DeptVideo implements Serializable {

    private static final long serialVersionUID = -594076170058276436L;

    /**
 	* 部门ID
	*/
    @JsonProperty("href")
    private String deptId;

    /**
	* 部门名称
	*/
    @JsonProperty("text")
    private String deptName;

    /**
	* 上级部门 ID
	*/
    private String parentId;

    /**
	* 排序
	*/
    private Integer orderNum;

    /**
	* 创建时间
	*/
    @JsonIgnore
    private String createTime;

    /**
	* 修改时间
	*/
    @JsonIgnore
    private String modifyTime;

    private  String level;

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    private List<DeptVideo> nodes;
    private Integer vels;

    public String getDeptId() {
        return deptId;
    }

    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(String modifyTime) {
        this.modifyTime = modifyTime;
    }


    public List<DeptVideo> getNodes() {
        return nodes;
    }

    public void setNodes(List<DeptVideo> nodes) {
        this.nodes = nodes;
    }

    public Integer getVels() {
        return vels;
    }

    public void setVels(Integer vels) {
        this.vels = vels;
    }
}