package im.zhaojun.common.config;

import im.zhaojun.system.model.ResultObj;
import im.zhaojun.system.model.Traffalarmrecord;
import im.zhaojun.system.model.VideoDeviceTraffic;
import im.zhaojun.system.service.EventWriteService;
import im.zhaojun.system.service.TraffFlowService;
import im.zhaojun.system.service.TraffalarmrecordService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.List;

@Slf4j
//@Component
//@Configuration
//@EnableScheduling
public class ScheduleTaskConfig {
    @Autowired
    TraffFlowService traffFlowService;

    @Autowired
    TraffalarmrecordService traffalarmrecordService;
    @Autowired
    EventWriteService eventWriteService;


    /***
     * 每2分钟执行一次查询事件推送给广达
     */
//    @Scheduled(cron = "0 */2 * * * ?")
    private void sendToguangdaEvent() {
        //查询所有未推送的数据
        List<Traffalarmrecord> resultlist = traffalarmrecordService.getTraffalarmrecordBystatus();
        for (Traffalarmrecord record : resultlist) {
            try {
                ResultObj obj = eventWriteService.updateAndAutoSendEvent(record);
                log.error( "2 min  send to guangda result"+obj.getMsg()+obj.getStatus());
                } catch (Exception ex) {
                log.error(record.getRecordid() + " send to guangda fail" + ex.toString());
            }
        }

    }

    /***
     * 每5分钟执行一次查询车流推送给广达
     */
    @Scheduled(cron = "0 */5 * * * ?")
    private void sendToguangdaDevice() {
        log.info("fiveflow  sendto guangda" );
        //查询所有未推送的数据
        List<VideoDeviceTraffic>  trafflist = traffFlowService.getfiveFlowByVideoid(null);
        if(trafflist.size()>0) {
            log.info("fiveflow" + trafflist.get(0).toString());
            traffFlowService.sendMessages(trafflist);
        }
    }


//    @Scheduled(cron = "0 30/5 6-19 * * ?")//每隔5分钟统计当天目前为止的数据
//    private void statistoday() {
//        //判断是否为空表
//        //执行查询存在更新，不存在新增
//        log.info("每隔5分钟");
//       Integer result= traffFlowService.insertOrUpdatevehicleTodaystatistic();
//        log.info("today"+result);
//
//    }

}
