

let vue_iframe = new Vue({
    el: '#src_iframe1',
    data: {
        src: '',
        show:'',
    },
});
let vue_tree = new Vue({
    el: '#page-sy',
    data: {
        data_tree: [],
        show:'',
        data_ul: [
            // {text: '首页', tags: 0, src: '/index'},
        ],
        cur: 0,
        src: '',
    },
    methods: {
        resize: function (item) {
            vue_tree.src = item.src;
        }
    },
    mounted(){
        if (geturl("url").indexOf('/') < 0) {
            vue_iframe.show = false;
            this.show = true;
            $.ajax({
                url: "/secondmenu",
                dataType: "json",
                type: "POST",
                data: {
                    "username": getCookie("bjpt_realName"),
                    "menuid": geturl("id"),
                },
                success: function (result) {
                    vue_tree.data_tree = [];
                    if (result.code == 0) {
                        if (result.data.length > 0) {
                            result.data.reverse();
                            result.data.forEach((item, index)=> {
                                vue_tree.data_tree.push({
                                    text: item.MENU_NAME,
                                    state: {selected: false},
                                    icon: 'glyphicon glyphicon-tasks',
                                    tags: index,
                                    src: item.URL,
                                })
                                vue_tree.data_ul.push({
                                    text: item.MENU_NAME,
                                    tags: index,
                                    src: item.URL,
                                })
                            });
                            vue_tree.data_tree[0].state.selected = true;
                            vue_tree.src = vue_tree.data_ul[0].src;
                            $('#tree-ul').treeview({
                                data: vue_tree.data_tree,
                                levels: 5,
                                color: '#aaaaaa',
                                backColor: '#ffffff00',
                                selectedBackColor: '#393F55',
                                selectedColor: '#ffffff',
                                onhoverColor: '#ffffff00',
                                showBorder: false,
                                onNodeSelected: function (event, node) {
                                    vue_tree.src = node.src;
                                    vue_tree.cur = node.tags;
                                    $(".content-sjfx>div").removeClass("active");
                                    $(".content-sjfx").children().eq(node.tags).addClass("active");
                                }
                            });
                        }
                    }
                }
            });
        }else{
            this.show = false;
            vue_iframe.show = true;
            vue_iframe.src = geturl("url");
        }
    }
});


function geturl(name) {
    var reg = new RegExp("[^\?&]?" + encodeURI(name) + "=[^&]+");
    var arr = window.parent.document.getElementById("iframes").contentWindow.location.search.match(reg);
    if (arr != null) {
        return decodeURI(arr[0].substring(arr[0].search("=") + 1));
    }
    return "";
}
