package im.zhaojun.system.controller;

import im.zhaojun.common.annotation.OperationLog;
import im.zhaojun.common.util.DateUtils;
import im.zhaojun.system.model.Menu;
import im.zhaojun.system.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Controller
@Slf4j
public class IndexController {

    @Resource
    private MenuService menuService;

    @Resource
    private LoginLogService loginLogService;

    @Resource
    private UserService userService;

    @Resource
    private RoleService roleService;

    @Resource
    private SysLogService sysLogService;

    @Resource
    private UserOnlineService userOnlineService;


    @Value("${devicesend.timeout}")
    private Integer timeout;

    @Value("${flvurl}")
    private String flvurl;

    @Value("${json.resisurl}")
    private String resisjsonvalue;

    @Autowired
    private RestTemplate restTemplate;


    @GetMapping(value = { "/main"})
    public String index(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "main";
    }
    @GetMapping(value = { "/qxindex"})
    public String qxindex(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "index";
    }

    @GetMapping(value = { "/pub_index"})
    public String pagepub_index(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/pub_index";
    }
    @GetMapping(value = { "/sjcx"})
    public String pagesjcx(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjcx";
    }
    @GetMapping(value = { "/jkgl"})
    public String pagejkgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/jkgl";
    }
    @GetMapping(value = { "/sjfx"})
    public String pagesjfx(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjfx";
    }
    @GetMapping(value = { "/jgsbgl"})
    public String pagejgsbgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/jgsbgl";
    }
    @GetMapping(value = { "/tsgl"})
    public String pagetsgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/tsgl";
    }
    @GetMapping(value = { "/xtgl"})
    public String pagextgl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/xtgl";
    }
    @GetMapping(value = { "/index"})
    public String pageindex(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/index";
    }

    @GetMapping(value = { "/gcjl"})
    public String pagegcjl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/gcjl";
    }


    @GetMapping(value = { "/manualscreen"})
    public String manualscreen(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/manualscreen";
    }


    @GetMapping(value = { "/symrjk"})
    public String pagesymrjk(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/symrjk";
    }

    @GetMapping(value = { "/sjdj"})
    public String pagesjdj(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjdj";
    }

    @GetMapping(value = { "/sjts"})
    public String pagesjts(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjts";
    }

    @GetMapping(value = { "/sbts"})
    public String pagesbts(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sbts";
    }

    @GetMapping(value = { "/tstj"})
    public String pagetstj(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/tstj";
    }

    @GetMapping(value = { "/sjzdbz"})
    public String pagesjzdbz(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sjzdbz";
    }
    @OperationLog("访问我的桌面")
    @GetMapping("/welcome")
    public String welcome(Model model) {
        int userCount = userService.count();
        int roleCount = roleService.count();
        int menuCount = menuService.count();
        int loginLogCount = loginLogService.count();
        int sysLogCount = sysLogService.count();
        int userOnlineCount = userOnlineService.count();

        model.addAttribute("userCount", userCount);
        model.addAttribute("roleCount", roleCount);
        model.addAttribute("menuCount", menuCount);
        model.addAttribute("loginLogCount", loginLogCount);
        model.addAttribute("sysLogCount", sysLogCount);
        model.addAttribute("userOnlineCount", userOnlineCount);
        return "welcome";
    }
    @OperationLog("设备统一管理")
    @GetMapping("/sbtygl")
    public String sbtygl(Model model) {
        List<Menu> menuTreeVOS = menuService.selectCurrentUserMenuTree();
        model.addAttribute("menus", menuTreeVOS);
        return "page/sbtygl";
    }

    @OperationLog("查看近七日登录统计图")
    @GetMapping("/weekLoginCount")
    @ResponseBody
    public List<Integer> recentlyWeekLoginCount() {
        return loginLogService.recentlyWeekLoginCount();
    }


    @GetMapping("/getflv/{videoid}")
    @ResponseBody
    public String  getflv(@PathVariable("videoid") String videoid) {
        String result;
        try {
            result = CompletableFuture.supplyAsync(() ->restTemplate.getForObject(flvurl+"/"+videoid, String.class)).get(timeout, TimeUnit.MILLISECONDS);

        }catch (TimeoutException e) {
            result= "";
       } catch (Exception e) {
            result= "";
        }
        return result;

    }

    //获取json地址
    @GetMapping("/getjson/{videoid}")
    @ResponseBody
    public String getjson(@PathVariable("videoid") String videoid) {
        String result = "";
        String url = resisjsonvalue + "/" + videoid + "/" + DateUtils.getDate();
        HttpHeaders headers = new HttpHeaders();
        HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
        RestTemplate client = new RestTemplate();
        try {
            ResponseEntity<String> request = client.exchange(url, HttpMethod.GET, requestEntity, String.class);
            log.info(url + "response=======" + request.getBody());
            result = getMatcher("<li><span.*<a href=\".*\">(.*)\\s+\\(.*</li>",request.getBody());
        } catch (Exception ex) {
            log.info(url + "response=======" + ex.toString());
        }

        log.info("json" + result);
        return url+"/"+result;

    }

    public static String getMatcher(String regex, String source) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        List<String> list = new ArrayList<>();
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        if (list.size() > 1) {
            return list.get(list.size() - 2);
        }
        return null;
    }


    //获取json地址
    @GetMapping("/test/{videoid}")
    @ResponseBody
    public String test(@PathVariable("videoid") String videoid) {
        String url = resisjsonvalue + "/" + videoid + "/" + DateUtils.getDate();
            String  str="<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n" +
                    "<title>文件索引</title>\n" +
                    "</head>\n" +
                    "<body>\n" +
                    "<h1>文件索引:/record/ecvs/video1/2021-01-04/</h1>\n" +
                    "<li><a href=\"http://33.50.1.21:57081/\">根目录</a></li>\n" +
                    "<li><a href=\"http://33.50.1.21:57081/record/ecvs/video1/\">上级目录</a></li>\n" +
                    "<li><span>0</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-42.json\">15-45-42.json (963.79KB)</a></li>\n" +
                    "<li><span>1</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-42.mp4\">15-45-42.mp4 (2.89MB)</a></li>\n" +
                    "<li><span>2</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-48.json\">15-45-48.json (987.03KB)</a></li>\n" +
                    "<li><span>3</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-48.mp4\">15-45-48.mp4 (1.87MB)</a></li>\n" +
                    "<li><span>4</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-52.json\">15-45-52.json (1.87MB)</a></li>\n" +
                    "<li><span>5</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-52.mp4\">15-45-52.mp4 (2.84MB)</a></li>\n" +
                    "<li><span>6</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-58.json\">15-45-58.json (910.83KB)</a></li>\n" +
                    "<li><span>7</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-45-58.mp4\">15-45-58.mp4 (1.84MB)</a></li>\n" +
                    "<li><span>8</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-02.json\">15-46-02.json (367.12KB)</a></li>\n" +
                    "<li><span>9</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-02.mp4\">15-46-02.mp4 (2.13MB)</a></li>\n" +
                    "<li><span>10</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-06.json\">15-46-06.json (570.40KB)</a></li>\n" +
                    "<li><span>11</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-06.mp4\">15-46-06.mp4 (1.88MB)</a></li>\n" +
                    "<li><span>12</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-10.json\">15-46-10.json (676.08KB)</a></li>\n" +
                    "<li><span>13</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-10.mp4\">15-46-10.mp4 (2.85MB)</a></li>\n" +
                    "<li><span>14</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-16.json\">15-46-16.json (668.19KB)</a></li>\n" +
                    "<li><span>15</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-16.mp4\">15-46-16.mp4 (1.84MB)</a></li>\n" +
                    "<li><span>16</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-20.json\">15-46-20.json (1.24MB)</a></li>\n" +
                    "<li><span>17</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-20.mp4\">15-46-20.mp4 (2.85MB)</a></li>\n" +
                    "<li><span>18</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-26.json\">15-46-26.json (1.33MB)</a></li>\n" +
                    "<li><span>19</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-26.mp4\">15-46-26.mp4 (2.80MB)</a></li>\n" +
                    "<li><span>20</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-32.json\">15-46-32.json (1.09MB)</a></li>\n" +
                    "<li><span>21</span>\t<a href=\"http://33.50.1.21:57081/record/ecvs/video1/2021-01-04/15-46-32.mp4\">15-46-32.mp4 (1.90MB)</a></li>\n" +
                    "<ul>\n" +
                    "</ul>\n" +
                    "</body></html>";
           String result = getMatcher("<li><span.*<a href=\".*\">(.*)\\s+\\(.*</li>",str );

        log.info("json" + result);
        return url+"/"+result;

    }

}
