package im.zhaojun.system.controller;

import com.github.pagehelper.PageInfo;
import im.zhaojun.common.annotation.OperationLog;
import im.zhaojun.common.annotation.RefreshFilterChain;
import im.zhaojun.common.util.PageResultBean;
import im.zhaojun.common.util.ResultBean;
import im.zhaojun.common.validate.groups.Create;
import im.zhaojun.system.model.Menu;
import im.zhaojun.system.model.User;
import im.zhaojun.system.model.Video;
import im.zhaojun.system.service.MenuService;
import im.zhaojun.system.service.VideoService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping("/video")
public class VideoController {

    @Resource
    private VideoService videoService;


    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");


    @OperationLog("根据deptId获取用户列表")
    @GetMapping("/list")
    @ResponseBody
    public PageResultBean<Video> getList(@RequestParam(value = "page", defaultValue = "1") int page,
                                        @RequestParam(value = "pageSize", defaultValue = "10") int pageSize,
                                        @RequestParam(value = "deptId") String deptId,
                                        @RequestParam(value = "videoName") String videoName) {

        List<Video> videos = videoService.selectByMutiParam(page, pageSize,deptId,videoName);
        PageInfo<Video> userPageInfo = new PageInfo<>(videos);
        return new PageResultBean<Video>(userPageInfo.getTotal(), userPageInfo.getList());

    }


    @OperationLog("新增监控")
    @PostMapping("/add")
    @ResponseBody
    public ResultBean add(Video video) {
        video.setCreateTime(sdf.format(new Date()));
        video.setModifyTime(video.getCreateTime());
        return ResultBean.success(videoService.add(video));
    }

    @OperationLog("删除监控")
    @GetMapping("/delete/{Id}")
    @ResponseBody
    public ResultBean delete(@PathVariable("Id") String id) {
        videoService.delete(id);
        return ResultBean.success();
    }


    @OperationLog("更新角色")
    @PostMapping("/edit")
    @ResponseBody
    public ResultBean update(@Valid Video video) {
        video.setModifyTime(sdf.format(new Date()));
        videoService.update(video);
        return ResultBean.success();
    }

   }