package im.zhaojun.system.service;

import com.github.pagehelper.PageHelper;
import im.zhaojun.common.shiro.ShiroActionProperties;
import im.zhaojun.common.util.ShiroUtil;
import im.zhaojun.common.util.TreeUtil;
import im.zhaojun.system.mapper.VideoMapper;
import im.zhaojun.system.model.Menu;
import im.zhaojun.system.model.User;
import im.zhaojun.system.model.Video;
import org.apache.shiro.authz.UnauthorizedException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class VideoService {

    @Resource
    private VideoMapper videoMapper;

    /**
     * 根据父 ID 获取所有部门下的监控信息
     */
    public List<Video> selectByMutiParam(int page, int  rows,String deptId,String videoName) {
        PageHelper.startPage(page, rows);
        return videoMapper.selectByMutiParam(deptId,videoName);
    }

    @Transactional
    public Integer add(Video video) {
        return videoMapper.insert(video);
    }


    @Transactional
    public void delete(String  id) {
        videoMapper.delete(id);
    }


    public void update(Video video) {
        videoMapper.updateByPrimaryKey(video);
    }
}