/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQQueueProperty;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;

public class AQjmsDestination
implements Queue,
Topic,
Serializable,
TemporaryQueue,
TemporaryTopic {
    private int type;
    private String owner;
    private String name;
    private String table;
    private int pload_type;
    private String p_data_type;
    private AQjmsDestinationProperty property;
    private Hashtable dest_properties;
    private Hashtable trans_list;
    private boolean secure;
    private boolean is_temp;
    private int temp_cons = 0;

    AQjmsDestination(String owner, String name, int dest_type, int payload_type, String adt_type, String table, boolean is_secure) throws JMSException {
        this.owner = owner;
        this.name = name;
        this.type = dest_type;
        this.p_data_type = payload_type == 2 ? null : adt_type;
        this.pload_type = payload_type;
        this.property = new AQjmsDestinationProperty();
        this.table = table;
        this.trans_list = new Hashtable();
        this.secure = is_secure;
        this.is_temp = false;
    }

    AQjmsDestination(String owner, String name, int dest_type, int payload_type, String adt_type, AQjmsDestinationProperty dest_property, String table, boolean is_secure) throws JMSException {
        this.owner = owner;
        this.name = name;
        this.type = dest_type;
        this.p_data_type = payload_type == 2 ? null : adt_type;
        this.property = dest_property;
        this.table = table;
        this.trans_list = new Hashtable();
        this.secure = is_secure;
        this.is_temp = false;
    }

    public String getQueueName() throws JMSException {
        if (this.type == 10) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getTopicName() throws JMSException {
        if (this.type == 20) {
            return this.name;
        }
        AQjmsOracleDebug.println("Type: " + this.type);
        return null;
    }

    public String getQueueOwner() throws JMSException {
        return this.owner;
    }

    public String getTopicOwner() throws JMSException {
        return this.owner;
    }

    String getAdtType() {
        return this.p_data_type;
    }

    int getPloadType() {
        return this.pload_type;
    }

    String getQueueTableName() {
        return this.table;
    }

    AQjmsDestinationProperty getProperty() {
        return this.property;
    }

    public String getCompleteName() {
        String ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return ret;
    }

    public String getCompleteTableName() {
        String ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.table : this.table;
        return ret;
    }

    public String toString() {
        String ret = null;
        ret = this.owner != null && !this.owner.equals("") ? this.owner + "." + this.name : this.name;
        return ret;
    }

    public void start(Session session, boolean enqueue, boolean dequeue) throws JMSException {
        this.start(session, enqueue, dequeue, false);
    }

    public void start(Session session, boolean enqueue, boolean dequeue, boolean autonomous) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.start(enqueue, dequeue, autonomous);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void stop(Session session, boolean enqueue, boolean dequeue, boolean wait) throws JMSException {
        this.stop(session, enqueue, dequeue, wait, false);
    }

    public void stop(Session session, boolean enqueue, boolean dequeue, boolean wait, boolean autonomous) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.stop(enqueue, dequeue, wait, autonomous);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void alter(Session session, AQjmsDestinationProperty dest_property) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.alterQueue(dest_property);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void drop(Session session) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.drop();
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void schedulePropagation(Session session, String destination, Date start_time, Double duration, String next_time, Double latency) throws JMSException {
        this.schedulePropagation(session, destination, null, start_time, duration, next_time, latency);
    }

    public void schedulePropagation(Session session, String destination, String dest_queue, Date start_time, Double duration, String next_time, Double latency) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.schedulePropagation(destination, dest_queue, start_time, duration, next_time, latency);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void unschedulePropagation(Session session, String destination) throws JMSException {
        this.unschedulePropagation(session, destination, null);
    }

    public void unschedulePropagation(Session session, String destination, String dest_queue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.unschedulePropagation(destination, dest_queue);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void alterPropagationSchedule(Session session, String destination, Double duration, String next_time, Double latency) throws JMSException {
        this.alterPropagationSchedule(session, destination, null, duration, next_time, latency);
    }

    public void alterPropagationSchedule(Session session, String destination, String dest_queue, Double duration, String next_time, Double latency) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.alterPropagationSchedule(destination, dest_queue, duration, next_time, latency);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void enablePropagationSchedule(Session session, String destination) throws JMSException {
        this.enablePropagationSchedule(session, destination, null);
    }

    public void enablePropagationSchedule(Session session, String destination, String dest_queue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.enablePropagationSchedule(destination, dest_queue);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void disablePropagationSchedule(Session session, String destination) throws JMSException {
        this.disablePropagationSchedule(session, destination, null);
    }

    public void disablePropagationSchedule(Session session, String destination, String dest_queue) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.disablePropagationSchedule(destination, dest_queue);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void grantQueuePrivilege(Session session, String privilege, String grantee, boolean grant_option) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.grantQueuePrivilege(privilege, grantee, grant_option);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void grantTopicPrivilege(Session session, String privilege, String grantee, boolean grant_option) throws JMSException {
        this.grantQueuePrivilege(session, privilege, grantee, grant_option);
    }

    public void revokeQueuePrivilege(Session session, String privilege, String grantee) throws JMSException {
        AQOracleQueue aq_queue = null;
        try {
            aq_queue = new AQOracleQueue((AQjmsSession)session, this.owner, this.name, this.table, (AQQueueProperty)this.property, this.pload_type, this.p_data_type, this.secure);
            aq_queue.revokeQueuePrivilege(privilege, grantee);
            aq_queue.close();
        }
        catch (AQException aq_ex) {
            throw new AQjmsException(aq_ex);
        }
    }

    public void revokeTopicPrivilege(Session session, String privilege, String grantee) throws JMSException {
        this.revokeQueuePrivilege(session, privilege, grantee);
    }

    boolean isQueue() {
        return this.type == 10;
    }

    boolean isTopic() {
        return this.type == 20;
    }

    public boolean isSecure() {
        return this.secure;
    }

    Hashtable getTransTable() {
        return this.trans_list;
    }

    void setTransTable(Hashtable t_list) {
        this.trans_list = t_list;
    }

    public AQjmsDestination cloneDestination() throws JMSException {
        AQjmsDestination c_dest = null;
        c_dest = new AQjmsDestination(this.owner, this.name, this.type, this.pload_type, this.p_data_type, this.table, this.secure);
        c_dest.setTransTable((Hashtable)this.trans_list.clone());
        return c_dest;
    }

    boolean isTemp() {
        return this.is_temp;
    }

    void makeTemp() {
        this.is_temp = true;
    }

    public void delete() throws JMSException {
        if (this.is_temp) {
            if (this.temp_cons > 0) {
                AQjmsError.throwEx(241);
            }
            AQjmsConnection.findCloseTemp(this);
        }
    }

    synchronized void addConsForTempDest() {
        if (this.is_temp) {
            ++this.temp_cons;
        }
    }

    synchronized void removeConsForTempDest() {
        if (this.is_temp) {
            --this.temp_cons;
        }
    }
}

