/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import oracle.sql.BLOB;
import oracle.sql.CLOB;

class ResourceMgr {
    private static CLOB shareClob = null;
    private static BLOB shareBlob = null;
    private static Connection db_conn = null;

    ResourceMgr() {
    }

    static Connection getConnection() throws SQLException {
        if (db_conn == null) {
            db_conn = DriverManager.getConnection("jdbc:default:connection:");
        }
        return db_conn;
    }

    static CLOB getSharedClob() throws SQLException {
        if (shareClob == null) {
            shareClob = CLOB.createTemporary((Connection)ResourceMgr.getConnection(), (boolean)true, (int)10);
        } else {
            shareClob.trim(0L);
        }
        return shareClob;
    }

    static BLOB getSharedBlob() throws SQLException {
        if (shareBlob == null) {
            shareBlob = BLOB.createTemporary((Connection)ResourceMgr.getConnection(), (boolean)true, (int)10);
        } else {
            shareBlob.trim(0L);
        }
        return shareBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clean() throws SQLException {
        SQLException sqe = null;
        if (shareClob != null) {
            try {
                shareClob.freeTemporary();
            }
            catch (SQLException sqe1) {
                sqe = sqe1;
            }
            finally {
                shareClob = null;
            }
        }
        if (shareBlob != null) {
            try {
                shareBlob.freeTemporary();
            }
            catch (SQLException sqe2) {
                sqe = sqe2;
            }
            finally {
                shareBlob = null;
            }
        }
        if (sqe != null) {
            throw sqe;
        }
    }
}

