/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import oracle.jms.AQjmsConnectionFactory;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsUtil;
import oracle.jms.AQjmsXAConnection;
import oracle.jms.AQjmsXAResourceFactory;
import oracle.jms.WebLogicHelper;

public class AQjmsXAConnectionFactory
extends AQjmsConnectionFactory
implements XAConnectionFactory {
    private XADataSource m_xaDS = null;
    private AQjmsXAResourceFactory m_xaresFactory = null;

    AQjmsXAConnectionFactory(String hostname, String oracle_sid, int portno, String driver) throws JMSException {
        super(hostname, oracle_sid, portno, driver);
    }

    AQjmsXAConnectionFactory(String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        super(jdbc_connect_str, jdbc_props);
    }

    AQjmsXAConnectionFactory(DataSource dsobj, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        super(dsobj);
        this.m_xaresFactory = xaresFactory;
    }

    AQjmsXAConnectionFactory(DataSource dsobj, String jdbc_connect_str, Properties jdbc_props) throws JMSException {
        super(dsobj, jdbc_connect_str, jdbc_props);
    }

    AQjmsXAConnectionFactory(String dsname, AQjmsXAResourceFactory xaresFactory) throws JMSException {
        super(dsname);
        this.m_xaresFactory = xaresFactory;
    }

    AQjmsXAConnectionFactory(XADataSource xaDS) throws JMSException {
        this.m_xaDS = xaDS;
    }

    AQjmsXAConnectionFactory(String xaDSName) throws JMSException {
        this.m_xaDS = (XADataSource)AQjmsUtil.lookupObject(xaDSName, XADataSource.class);
        AQjmsOracleDebug.trace(5, "AQjmsXAConnectionFactory - constructor", "XA data source name: " + xaDSName);
    }

    public AQjmsXAConnectionFactory() {
    }

    public XAConnection createXAConnection() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmXAConnectionFactory.createXAConnection", "enter");
        AQjmsXAConnection conn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            conn = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, 30);
        } else {
            conn = this.jdbc_conn_str != null ? new AQjmsXAConnection(this.jdbc_conn_str, this.jdbc_info, 30) : (this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, null, null, 30) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, null, null, 30) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, null, null, this.jdbc_driver, 30)));
        }
        conn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmXAConnectionFactory.createXAConnection", "XAConnection created successfully");
        return conn;
    }

    public XAConnection createXAConnection(String userName, String password) throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsXAConnectionFactory.createXAConnection", "with user/pwd");
        AQjmsXAConnection conn = null;
        if (WebLogicHelper.runningInWLServer()) {
            if (this.data_source == null) {
                throw new UnsupportedOperationException("WebLogic server side components must use AQ JMS datasource configuration");
            }
            conn = new AQjmsXAConnection(this.data_source, this.m_xaresFactory, userName, password, 30);
        } else {
            Properties new_info = null;
            if (this.jdbc_conn_str != null) {
                if (this.jdbc_info != null) {
                    if (userName != null || password != null) {
                        new_info = (Properties)this.jdbc_info.clone();
                        new_info.put("user", userName);
                        new_info.put("password", password);
                    } else {
                        new_info = this.jdbc_info;
                    }
                    conn = new AQjmsXAConnection(this.jdbc_conn_str, new_info, 30);
                } else {
                    conn = new AQjmsXAConnection(this.jdbc_conn_str, userName, password, 30);
                }
            } else {
                conn = this.m_xaDS != null ? new AQjmsXAConnection(this.m_xaDS, userName, password, 30) : (this.data_source != null ? new AQjmsXAConnection(this.data_source, this.m_xaresFactory, userName, password, 30) : new AQjmsXAConnection(this.hostname, this.oracle_sid, this.portno, userName, password, this.jdbc_driver, 30));
            }
        }
        conn.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(5, "AQjmsXAConnectionFactory.createXAConnection w/username/password", "XAConnection created successfully");
        return conn;
    }
}

