/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.StringReader;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsDeqSel;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsParser;
import oracle.jms.ParseException;
import oracle.jms.TokenMgrError;

class AQjmsSelector {
    String selector;
    String rule;
    String sel_corr_id;
    byte[] sel_msg_id;
    int sel_type = 0;
    String adt_rule;
    boolean compliant;

    AQjmsSelector(String selector, int dest_type, int dest_pload_type, boolean is82compatible, boolean compliant) throws JMSException {
        this.selector = selector;
        this.sel_corr_id = null;
        this.sel_msg_id = null;
        this.adt_rule = null;
        this.compliant = compliant;
        AQjmsOracleDebug.trace(4, "AQjmsSelector-constructor", "entry");
        AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "selector: " + selector + " dest_type: " + dest_type + " dest_pload_type: " + dest_pload_type);
        if (dest_pload_type == 2) {
            if (dest_type == 10) {
                AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "adt_type - dest=QUEUE");
                this.sel_type = 50;
                this.rule = selector;
            } else {
                this.setAdtRule(selector);
                this.sel_type = 40;
            }
            return;
        }
        if (dest_type == 10) {
            if (!is82compatible || selector.indexOf("JMSCorrelationID") != -1 || selector.indexOf("JMSMessageID") != -1) {
                try {
                    this.sel_type = this.parseDeqSelector(selector + ";", dest_type);
                }
                catch (InvalidSelectorException ex) {
                    if (is82compatible) {
                        this.AQjmsSelCnd(selector, dest_type, dest_pload_type);
                    }
                    throw ex;
                }
                if (is82compatible && this.sel_type == 0) {
                    this.AQjmsSelCnd(selector, dest_type, dest_pload_type);
                }
                AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "Prior v8.2:\nselector_type: " + this.sel_type + "   sel_msg_id: " + this.sel_msg_id + "   sel_corr_id: " + this.sel_corr_id);
            } else {
                this.AQjmsSelCnd(selector, dest_type, dest_pload_type);
            }
        } else if (dest_type == 20) {
            this.AQjmsSelCnd(selector, dest_type, dest_pload_type);
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSelector-constructor", "INTERNAL_ERROR - invalid destination type");
            AQjmsError.throwEx(122, "Invalid destination type");
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", this.getTrace());
        AQjmsOracleDebug.trace(4, "AQjmsSelector-constructor", "exit");
    }

    private void AQjmsSelCnd(String selector, int dest_type, int dest_pload_type) throws JMSException {
        if (this.sel_type != 0) {
            AQjmsOracleDebug.trace(5, "AQjmsSelector.AQjmsSelCnd", "sel_type: " + this.sel_type);
            AQjmsOracleDebug.trace(5, "AQjmsSelector.AQjmsSelCnd", "dest_type: " + dest_type);
            AQjmsOracleDebug.trace(5, "AQjmsSelector.AQjmsSelCnd", "dest_pload_type: " + dest_pload_type);
        }
        try {
            this.rule = this.parseRule(selector + ";", dest_pload_type);
        }
        catch (TokenMgrError err) {
            AQjmsOracleDebug.traceErr(3, "Token Mgr Error - Invalid selector", err);
            AQjmsError.throwInvalidSelectorEx(159, "Token Mgr Error", err);
        }
        if (this.rule != null) {
            AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "rule_len: " + this.rule.length());
            AQjmsOracleDebug.trace(5, "AQjmsSelector-constructor", "rule: " + this.rule);
        }
        if (this.rule.length() > 4000) {
            AQjmsError.throwInvalidSelectorEx(159, "Rule Parse error - exceeded 4000 characters");
        }
        this.sel_type = dest_type == 10 ? 50 : 10;
    }

    public int parseDeqSelector(String parser_input, int dest_type) throws JMSException {
        AQjmsDeqSel parser = null;
        String expr = null;
        int sel_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseDeqSelector", "entry");
        parser = new AQjmsDeqSel(new StringReader(parser_input));
        try {
            expr = parser.DequeueSelector();
            AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "expr: " + expr);
            if (expr.equals("JMSMessageID")) {
                sel_type = 30;
                this.sel_msg_id = parser.msg_id;
                AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_msg_id: " + RepConversion.bArray2String((byte[])this.sel_msg_id));
            } else if (expr.equals("JMSCorrelationID")) {
                sel_type = 20;
                this.sel_corr_id = parser.corr_id;
                AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_corr_id: " + this.sel_corr_id);
            } else {
                sel_type = 0;
            }
        }
        catch (ParseException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSelector.parseDeqSelector- parseEx", ex);
            AQjmsError.throwInvalidSelectorEx(159, "Selector Parse error", ex);
        }
        catch (TokenMgrError err) {
            AQjmsOracleDebug.traceErr(3, "AQjmsSelector.parseDeqSelector- TokenMgrErr", err);
            AQjmsError.throwInvalidSelectorEx(159, "Selector Parse error: " + err.getMessage(), err);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector.parseDeqSelector", "sel_type" + sel_type);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseDeqSelector", "exit");
        return sel_type;
    }

    public String parseRule(String parser_input, int dest_pload_type) throws JMSException {
        AQjmsParser parser = null;
        String rule = null;
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "entry");
        parser = new AQjmsParser(new StringReader(parser_input));
        parser.setDestPayloadType(dest_pload_type);
        parser.setCompliant(this.compliant);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "set the <compliant> of AQjmsParser to:" + this.compliant);
        try {
            rule = parser.SubscriberRule();
            AQjmsOracleDebug.println("\nMessage parsed successfully");
        }
        catch (ParseException ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSelector.parseRule - parseEx", ex);
            AQjmsError.throwInvalidSelectorEx(159, "Rule Parse error", ex);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSelector.parseRule", "rule: " + rule);
        AQjmsOracleDebug.trace(4, "AQjmsSelector.parseRule", "exit");
        return rule;
    }

    String getSelectorString() {
        return this.selector;
    }

    int getSelectorType() {
        return this.sel_type;
    }

    String getRule() {
        return this.rule;
    }

    String getSelectorCorrelationId() {
        return this.sel_corr_id;
    }

    byte[] getSelectorMessageId() {
        return this.sel_msg_id;
    }

    String getAdtRule() {
        return this.adt_rule;
    }

    void setAdtRule(String selector) throws JMSException {
        if (selector.length() > 4000) {
            AQjmsError.throwInvalidSelectorEx(159, "Adt Selector Parse error - exceeded 4000 characters");
        }
        this.adt_rule = selector;
        AQjmsOracleDebug.trace(5, "AQjmsSelector.setAdtRule", "adt_rule: " + this.adt_rule);
    }

    String getTrace() {
        StringBuffer buf = new StringBuffer();
        buf.append("[AQjmsSelector]");
        buf.append("\n  selector         : " + this.selector);
        buf.append("\n  rule             : " + this.rule);
        buf.append("\n  sel_corr_id      : " + this.sel_corr_id);
        buf.append("\n  adt_rule         : " + this.adt_rule);
        buf.append("\n  sel_msg_id       : " + AQjmsMessage.ByteArraytoString(this.sel_msg_id));
        buf.append("\n  sel_type         : " + this.sel_type);
        buf.append("\n");
        return buf.toString();
    }
}

