/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import oracle.jdbc.util.RepConversion;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessageFormatException;
import oracle.jms.AQjmsMessageHeaderExt;
import oracle.jms.AQjmsMessageID;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsPropDatum;
import oracle.jms.AQjmsProperty;
import oracle.jms.AQjmsPropertyList;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsSignature;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;

public class AQjmsMessage
implements Message {
    static final Class m_boolClass = new Boolean(false).getClass();
    static final Class m_byteClass = new Byte(0).getClass();
    static final Class m_shortClass = new Byte(0).getClass();
    static final Class m_intClass = new Integer(0).getClass();
    static final Class m_longClass = new Long(0L).getClass();
    static final Class m_floatClass = new Float(0.0f).getClass();
    static final Class m_doubleClass = new Double(0.0).getClass();
    static final Class m_strClass = new String(" ").getClass();
    static Hashtable m_systemProperties;
    static HashSet m_settableSystemProperties;
    AQjmsMessageHeaderExt header_ext;
    AQjmsMessageID message_id;
    long enqueue_time;
    String corr_id;
    Destination msg_dest;
    int del_mode;
    boolean redelivered;
    long expiration;
    int priority;
    Hashtable msg_properties;
    int access_mode;
    boolean prop_read_only;
    long recv_time;
    int msg_state;
    String excp_queue;
    int msg_delay;
    byte[] orig_msg_id;
    AQjmsAgent sender_id;
    int attempts;
    AQjmsSignature m_signature;
    AQjmsSession session;
    boolean m_hdrOnly;
    boolean m_isjmsbody;
    boolean compliant;
    private static final String JMS_REPLY_TO = "JMSReplyTo";
    boolean m_writeLobLater = false;
    Object m_tempLob = null;

    private void init(boolean jmsbody) {
        this.message_id = new AQjmsMessageID();
        this.enqueue_time = 0L;
        this.msg_dest = null;
        this.del_mode = 2;
        this.corr_id = "";
        this.redelivered = false;
        this.expiration = 0L;
        this.compliant = this.session == null ? AQjmsConstants.IS_COMPLIANT : this.session.getCompliant();
        this.priority = jmsbody && this.compliant ? 4 : 1;
        this.msg_properties = new Hashtable();
        this.access_mode = 2;
        this.prop_read_only = false;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.m_hdrOnly = false;
        this.m_isjmsbody = jmsbody;
        this.header_ext = new AQjmsMessageHeaderExt();
    }

    AQjmsMessage(boolean jmsbody) {
        this.init(jmsbody);
    }

    AQjmsMessage(AQjmsSession session, boolean jmsbody) {
        this.session = session;
        this.init(jmsbody);
    }

    AQjmsMessage(AQjmsMessage inmsg) {
        this(inmsg.session, inmsg.m_isjmsbody);
        this.header_ext = inmsg.header_ext;
        this.message_id = inmsg.message_id;
        this.enqueue_time = inmsg.enqueue_time;
        this.corr_id = inmsg.corr_id;
        this.msg_dest = inmsg.msg_dest;
        this.del_mode = inmsg.del_mode;
        this.redelivered = inmsg.redelivered;
        this.expiration = inmsg.expiration;
        this.priority = inmsg.priority;
        this.msg_properties = inmsg.msg_properties;
        this.access_mode = inmsg.access_mode;
        this.prop_read_only = inmsg.prop_read_only;
        this.recv_time = inmsg.recv_time;
        this.msg_state = inmsg.msg_state;
        this.excp_queue = inmsg.excp_queue;
        this.msg_delay = inmsg.msg_delay;
        this.orig_msg_id = inmsg.orig_msg_id;
        this.sender_id = inmsg.sender_id;
        this.attempts = inmsg.attempts;
        this.m_signature = inmsg.m_signature;
        this.m_hdrOnly = inmsg.m_hdrOnly;
    }

    AQjmsMessageHeaderExt getMessageHeaderExt() {
        return this.header_ext;
    }

    Hashtable getPropertiesHashtable() {
        return this.msg_properties;
    }

    void setPropertiesHashtable(Hashtable props) {
        this.msg_properties = props;
    }

    public String getJMSMessageID() throws JMSException {
        return this.message_id.getJMSMessageID();
    }

    public byte[] getJMSMessageIDAsBytes() throws JMSException {
        return this.message_id.getJMSMessageIDAsBytes();
    }

    void setJMSMessageID(byte[] id) throws JMSException {
        this.message_id.setJMSMessageID(id);
    }

    public void setJMSMessageID(String id) throws JMSException {
        this.message_id.setJMSMessageID(id);
    }

    public long getJMSTimestamp() throws JMSException {
        long timestamp;
        Object timeObj = this.getObjectProperty("JMS_OracleTimestamp");
        if (timeObj != null && timeObj instanceof Long) {
            timestamp = (Long)timeObj;
            AQjmsOracleDebug.trace(5, "AQjmsMessage.getJMSTimestamp", "JMSTimestamp from property:" + timestamp);
        } else {
            timestamp = this.getEnqueueTime();
            AQjmsOracleDebug.trace(5, "AQjmsMessage.getJMSTimestamp", "JMSTimestamp from AQ enqueue_time:" + timestamp);
        }
        return timestamp;
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.setLongProperty2("JMS_OracleTimestamp", timestamp);
        AQjmsOracleDebug.println("setJMSTimestamp. timestamp: " + timestamp);
    }

    long getEnqueueTime() {
        return this.enqueue_time;
    }

    void setEnqueueTime(long timestamp) {
        this.enqueue_time = timestamp;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (this.corr_id == null) {
            return null;
        }
        return this.corr_id.getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        this.corr_id = correlationID == null ? null : new String(correlationID);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.corr_id = correlationID;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.corr_id;
    }

    public Destination getJMSReplyTo() throws JMSException {
        Object ret = null;
        try {
            ret = this.header_ext.getReplyto();
            if (ret != null) {
                String n = ((AQjmsAgent)ret).getName();
                if (n != null && n.equalsIgnoreCase(JMS_REPLY_TO)) {
                    ret = AQjmsMessage.deserializeDest(((AQjmsAgent)ret).getAddress());
                }
                if (ret instanceof AQjmsAgent) {
                    String a = ((AQjmsAgent)ret).getAddress();
                    if ((n == null || n.equals("") || n.equals(" ")) && (a == null || a.equals(""))) {
                        ret = null;
                    }
                }
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        return ret;
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        try {
            if (replyTo instanceof AQjmsAgent) {
                String n = ((AQjmsAgent)replyTo).getName();
                if (n != null && n.equalsIgnoreCase(JMS_REPLY_TO)) {
                    AQjmsError.throwEx(147);
                }
                this.header_ext.setReplyto((AQjmsAgent)replyTo);
            } else if (replyTo instanceof AQjmsDestination) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, AQjmsMessage.serializeDest((AQjmsDestination)replyTo)));
            } else if (replyTo == null) {
                this.header_ext.setReplyto(new AQjmsAgent(JMS_REPLY_TO, null));
            } else {
                AQjmsError.throwEx(147);
            }
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public Destination getJMSDestination() throws JMSException {
        return this.msg_dest;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.msg_dest = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.del_mode;
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 2 && deliveryMode != 1) {
            AQjmsError.throwEx(101, Integer.toString(deliveryMode));
        }
        this.del_mode = deliveryMode;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.redelivered;
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.redelivered = redelivered;
    }

    public String getJMSType() throws JMSException {
        try {
            return this.header_ext.getType();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public void setJMSType(String type) throws JMSException {
        try {
            this.header_ext.setType(type);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
    }

    public long getJMSExpiration() throws JMSException {
        return this.expiration;
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        this.expiration = expiration;
    }

    public int getJMSPriority() throws JMSException {
        return this.priority;
    }

    public void setJMSPriority(int priority) throws JMSException {
        this.priority = priority;
    }

    public void clearProperties() throws JMSException {
        if (this.msg_properties != null) {
            this.msg_properties.clear();
        }
        if (this.header_ext != null) {
            try {
                this.header_ext.setUserid(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.header_ext.setAppid(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupid(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.header_ext.setGroupseq(null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.header_ext.setProperties(null);
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.clearProperties", ex);
            }
        }
        this.attempts = 0;
        this.msg_state = 0;
        this.recv_time = 0L;
        this.excp_queue = null;
        this.msg_delay = 0;
        this.orig_msg_id = null;
        this.m_signature = null;
        this.setPropReadOnly(false);
    }

    public boolean propertyExists(String name) throws JMSException {
        this.chkDeprecatedProp(name);
        if (m_systemProperties.containsKey(name)) {
            try {
                return this.getSystemProperty(name) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.msg_properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        Object value;
        block11: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.chkDeprecatedProp(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Boolean.valueOf(str);
                    }
                    break block11;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val = ((Datum)value).intValue();
                            return val != 0;
                        }
                        case 27: {
                            String str = (String)value;
                            return Boolean.valueOf(str);
                        }
                    }
                    break block11;
                }
                return false;
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public byte getByteProperty(String name) throws JMSException {
        Object value;
        block12: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.chkDeprecatedProp(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Byte.parseByte(str);
                    }
                    break block12;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: {
                            int val = ((Datum)value).intValue();
                            return (byte)val;
                        }
                        case 27: {
                            String str = (String)value;
                            return Byte.parseByte(str);
                        }
                    }
                    break block12;
                }
                throw new NumberFormatException("getByteProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public short getShortProperty(String name) throws JMSException {
        Object value;
        block12: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.chkDeprecatedProp(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Short.parseShort(str);
                    }
                    break block12;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: {
                            int val = ((Datum)value).intValue();
                            return (short)val;
                        }
                        case 27: {
                            String str = (String)value;
                            return Short.parseShort(str);
                        }
                    }
                    break block12;
                }
                throw new NumberFormatException("getShortProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public int getIntProperty(String name) throws JMSException {
        Object value;
        block13: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.chkDeprecatedProp(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null) {
                        if (cl == m_strClass) {
                            String str = (String)value;
                            return Integer.parseInt(str);
                        }
                        return ((Datum)value).intValue();
                    }
                    break block13;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)value).intValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Integer.parseInt(str);
                        }
                    }
                    break block13;
                }
                throw new NumberFormatException("getIntProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public long getLongProperty(String name) throws JMSException {
        Object value;
        block15: {
            AQjmsPropDatum prop_datum = null;
            value = null;
            this.chkDeprecatedProp(name);
            try {
                Class cl = (Class)m_systemProperties.get(name);
                if (cl != null) {
                    value = this.getSystemProperty(name);
                    if (value != null && cl == m_strClass) {
                        String str = (String)value;
                        return Long.parseLong(str);
                    }
                    if (cl == m_intClass) {
                        return ((Datum)value).intValue();
                    }
                    if (cl == m_longClass) {
                        return ((Datum)value).longValue();
                    }
                    break block15;
                }
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 21: 
                        case 22: 
                        case 23: {
                            return ((Datum)value).intValue();
                        }
                        case 24: {
                            return ((Datum)value).longValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return Long.parseLong(str);
                        }
                    }
                    break block15;
                }
                throw new NumberFormatException("getLongProperty() -> null");
            }
            catch (SQLException sq_ex) {
                throw new AQjmsMessageFormatException(sq_ex);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                AQjmsError.throwMsgFormatEx(117, e.getMessage());
            }
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public float getFloatProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.chkDeprecatedProp(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null && cl == m_strClass) {
                    String str = (String)value;
                    return new Float(str).floatValue();
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 25: {
                            return ((Datum)value).floatValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return new Float(str).floatValue();
                        }
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public double getDoubleProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.chkDeprecatedProp(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null && cl == m_strClass) {
                    String str = (String)value;
                    return new Double(str);
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 25: {
                            return ((Datum)value).floatValue();
                        }
                        case 26: {
                            return ((Datum)value).doubleValue();
                        }
                        case 27: {
                            String str = (String)value;
                            return new Double(str);
                        }
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        throw new NullPointerException();
    }

    public String getStringProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.chkDeprecatedProp(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                value = this.getSystemProperty(name);
                if (value != null) {
                    if (cl == m_strClass) {
                        return (String)value;
                    }
                    return ((Datum)value).stringValue();
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val = ((Datum)value).intValue();
                            if (val > 0) {
                                return "true";
                            }
                            return "false";
                        }
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: {
                            return ((Datum)value).stringValue();
                        }
                    }
                    return (String)value;
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public Object getObjectProperty(String name) throws JMSException {
        AQjmsPropDatum prop_datum = null;
        Object value = null;
        this.chkDeprecatedProp(name);
        try {
            Class cl = (Class)m_systemProperties.get(name);
            if (cl != null) {
                if (cl == m_strClass && (value = this.getSystemProperty(name)) != null) {
                    return value;
                }
                if (cl == m_intClass && (value = this.getSystemProperty(name)) != null) {
                    return new Integer(((Datum)value).intValue());
                }
                if (cl == m_longClass && (value = this.getSystemProperty(name)) != null) {
                    return new Long(((Datum)value).longValue());
                }
            } else {
                prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                if (prop_datum != null) {
                    value = prop_datum.getValue();
                    int type = prop_datum.getType();
                    switch (type) {
                        case 20: {
                            int val1 = ((Datum)value).intValue();
                            return new Boolean(val1 > 0);
                        }
                        case 21: {
                            int val2 = ((Datum)value).intValue();
                            return new Byte((byte)val2);
                        }
                        case 22: {
                            int val3 = ((Datum)value).intValue();
                            return new Short((short)val3);
                        }
                        case 23: {
                            int val4 = ((Datum)value).intValue();
                            return new Integer(val4);
                        }
                        case 24: {
                            long val41 = ((Datum)value).longValue();
                            return new Long(val41);
                        }
                        case 25: {
                            float val5 = ((Datum)value).floatValue();
                            return new Float(val5);
                        }
                        case 26: {
                            double val6 = ((Datum)value).doubleValue();
                            return new Double(val6);
                        }
                        case 27: {
                            return value;
                        }
                    }
                }
            }
        }
        catch (SQLException sq_ex) {
            throw new AQjmsMessageFormatException(sq_ex);
        }
        catch (Exception e) {
            AQjmsError.throwMsgFormatEx(117, e.getMessage());
        }
        if (value != null) {
            AQjmsError.throwMsgFormatEx(117, null);
        }
        return null;
    }

    public synchronized Enumeration getPropertyNames() throws JMSException {
        Vector<String> properties = new Vector<String>(this.msg_properties.size() + m_systemProperties.size());
        Enumeration my_enum = m_systemProperties.keys();
        while (my_enum.hasMoreElements()) {
            String propName = (String)my_enum.nextElement();
            try {
                if (this.compliant && this.getSystemProperty(propName) == null) continue;
                properties.addElement(propName);
            }
            catch (SQLException sqe) {
                AQjmsOracleDebug.traceEx(2, "AQjmsMessage.getPropertyNames", sqe);
                AQjmsError.throwEx(122, (Throwable)sqe);
            }
        }
        my_enum = this.msg_properties.keys();
        while (my_enum.hasMoreElements()) {
            properties.addElement((String)my_enum.nextElement());
        }
        return properties.elements();
    }

    public synchronized Enumeration getUserPropertyNames() throws JMSException {
        Vector<String> properties = new Vector<String>(this.msg_properties.size());
        Enumeration my_enum = this.msg_properties.keys();
        while (my_enum.hasMoreElements()) {
            String key = (String)my_enum.nextElement();
            if (AQjmsMessage.isSystemProperty(key)) continue;
            properties.addElement(key);
        }
        return properties.elements();
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(20, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(21, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(22, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsOracleDebug.println("setIntProperty: Property: " + name + " Value:  " + value);
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(23, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.setLongProperty2(name, value);
    }

    void setLongProperty2(String name, long value) throws JMSException {
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(24, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(25, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        try {
            NUMBER new_value = new NUMBER(value);
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, new_value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(26, (Datum)new_value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.setStringProperty2(name, value);
    }

    void setStringProperty2(String name, String value) throws JMSException {
        this.checkPropertyName(name);
        this.checkPropertyValue(name, value);
        try {
            if (AQjmsMessage.isSystemProperty(name)) {
                this.setSystemProperty(name, value);
            } else {
                AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, value);
                this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsError.throwEx(119, (Throwable)sql_ex);
        }
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (this.isPropReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        this.checkPropertyName(name);
        if (value == null) {
            AQjmsError.throwMsgFormatEx(119, null);
        }
        if (value instanceof Boolean) {
            this.setBooleanProperty(name, (Boolean)value);
        } else if (value instanceof Byte) {
            this.setByteProperty(name, (Byte)value);
        } else if (value instanceof Short) {
            this.setShortProperty(name, (Short)value);
        } else if (value instanceof Integer) {
            this.setIntProperty(name, (Integer)value);
        } else if (value instanceof Long) {
            this.setLongProperty(name, (Long)value);
        } else if (value instanceof Float) {
            this.setFloatProperty(name, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.setDoubleProperty(name, (Double)value);
        } else if (value instanceof String) {
            this.setStringProperty(name, (String)value);
        } else {
            AQjmsError.throwMsgFormatEx(119, null);
        }
    }

    public void acknowledge() throws JMSException {
        Connection db_conn = null;
        if (this.session.getAcknowledgeMode() == 2) {
            db_conn = this.session.getDBConnection();
            try {
                db_conn.commit();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
    }

    public void clearBody() throws JMSException {
    }

    public AQjmsAgent getSenderID() throws JMSException {
        return this.sender_id;
    }

    public void setSenderID(AQjmsAgent sender) throws JMSException {
        this.sender_id = sender;
    }

    public int getAttempts() throws JMSException {
        return this.attempts;
    }

    void setAttempts(int num_attempts) throws JMSException {
        this.attempts = num_attempts;
    }

    boolean isPropReadOnly() {
        return this.prop_read_only;
    }

    void setPropReadOnly(boolean value) {
        this.prop_read_only = value;
    }

    boolean isBodyReadOnly() {
        return this.access_mode == 0;
    }

    boolean isBodyWriteOnly() {
        return this.access_mode == 1;
    }

    boolean isBodyReadWrite() {
        return this.access_mode == 2;
    }

    void setAccessMode(int value) throws JMSException {
        if (value == 0 || value == 1 || value == 2) {
            this.access_mode = value;
        } else {
            AQjmsError.throwEx(152);
        }
    }

    static String ByteArraytoString(byte[] b) {
        StringBuffer buf = new StringBuffer();
        if (b == null) {
            buf.append("");
        } else {
            int n = b.length;
            for (int i = 0; i < n; ++i) {
                int v = b[i] & 0xFF;
                if (v < 16) {
                    buf.append("0" + Integer.toHexString(v));
                    continue;
                }
                buf.append(Integer.toHexString(v));
            }
        }
        return buf.toString();
    }

    static AQjmsPropertyList convertHashtableToPropertyList(Hashtable msg_props) throws JMSException {
        int num_props = 0;
        int i = 0;
        Enumeration value_enum = null;
        Enumeration name_enum = null;
        String curr_name = null;
        AQjmsPropDatum curr_value = null;
        Object d_value = null;
        num_props = msg_props.size();
        AQjmsOracleDebug.println("Num props " + num_props);
        AQjmsProperty[] properties = new AQjmsProperty[num_props];
        name_enum = msg_props.keys();
        value_enum = msg_props.elements();
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "entry");
        try {
            i = 0;
            while (name_enum.hasMoreElements()) {
                curr_name = (String)name_enum.nextElement();
                curr_value = (AQjmsPropDatum)value_enum.nextElement();
                d_value = curr_value.getValue();
                properties[i] = new AQjmsProperty();
                AQjmsOracleDebug.println("Property: " + i);
                AQjmsOracleDebug.println("Name: " + curr_name + "  Type: " + curr_value.getType());
                if (curr_value.getType() == 27) {
                    properties[i].setName(curr_name);
                    properties[i].setType(new Integer(100));
                    properties[i].setStrValue((String)d_value);
                    properties[i].setNumValue(null);
                    properties[i].setJavaType(new Integer(curr_value.getType()));
                    AQjmsOracleDebug.println("Name: " + curr_name + "  Value: " + (String)d_value + "  Str Type: " + curr_value.getType());
                } else if (d_value instanceof NUMBER) {
                    properties[i].setName(curr_name);
                    properties[i].setType(new Integer(200));
                    properties[i].setStrValue(null);
                    properties[i].setNumValue(((Datum)d_value).bigDecimalValue());
                    properties[i].setJavaType(new Integer(curr_value.getType()));
                    AQjmsOracleDebug.println("Name: " + curr_name + "  Value: " + ((Datum)d_value).bigDecimalValue() + "  Num Type: " + curr_value.getType());
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.convertHashtableToPropertyList", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                ++i;
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertHashtableToPropertyList", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsPropertyList prop_list = new AQjmsPropertyList(properties);
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertHashtableToPropertyList", "exit");
        return prop_list;
    }

    static Hashtable convertPropertyListToHashtable(AQjmsPropertyList prop_list) throws JMSException {
        Hashtable<String, AQjmsPropDatum> msg_props;
        int num_props = 0;
        int i = 0;
        Object value_enum = null;
        Object name_enum = null;
        String curr_name = null;
        AQjmsPropDatum curr_value = null;
        NUMBER d_value = null;
        String s_value = null;
        int java_type = 0;
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "entry");
        try {
            num_props = prop_list.length();
            msg_props = new Hashtable<String, AQjmsPropDatum>();
            AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "num_props: " + num_props);
            AQjmsProperty[] properties = new AQjmsProperty[num_props];
            for (i = 0; i < num_props; ++i) {
                properties[i] = prop_list.getElement(i);
                curr_name = properties[i].getName();
                Integer type = properties[i].getType();
                java_type = properties[i].getJavaType();
                if (type == 100) {
                    s_value = properties[i].getStrValue();
                    curr_value = new AQjmsPropDatum(java_type, s_value);
                } else if (type == 200) {
                    d_value = new NUMBER(properties[i].getNumValue());
                    curr_value = new AQjmsPropDatum(java_type, (Datum)d_value);
                } else {
                    AQjmsOracleDebug.trace(1, "AQjmsMessage.converPropertyListToHashtable", "Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                msg_props.put(curr_name, curr_value);
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsMessage.convertPropertyListToHashtable", "exit");
        return msg_props;
    }

    static void printPropertyList(AQjmsProperty[] properties) throws JMSException {
        int num_props = 0;
        int i = 0;
        Object value_enum = null;
        Object name_enum = null;
        String curr_name = null;
        Object curr_value = null;
        Object d_value = null;
        int java_type = 0;
        AQjmsOracleDebug.println("[PropertyList]");
        try {
            num_props = properties.length;
            for (i = 0; i < num_props; ++i) {
                curr_name = properties[i].getName();
                Integer type = properties[i].getType();
                AQjmsOracleDebug.print("Prop:" + i + "  Type: " + type);
                if (type == 100) {
                    AQjmsOracleDebug.println("  StrVal: " + properties[i].getStrValue());
                } else if (type == 200) {
                    AQjmsOracleDebug.println("  NumVal: " + properties[i].getNumValue());
                } else {
                    AQjmsOracleDebug.println("Internal error - invalid datum value");
                    AQjmsError.throwEx(122);
                }
                java_type = properties[i].getJavaType();
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsMessage.convertPropertyListToHashtable", sql_ex);
            throw new AQjmsException(sql_ex);
        }
    }

    static boolean isSystemProperty(String name) {
        return name != null && (name.startsWith("JMSX") || name.startsWith("JMS_Oracle"));
    }

    static boolean isSettableSystemProperty(String name) {
        return m_settableSystemProperties.contains(name);
    }

    void setSystemProperty(String name, Object value) throws JMSException, SQLException {
        block44: {
            try {
                if (m_systemProperties.containsKey(name)) {
                    if (name.equals("JMSXUserID")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMSXAppID")) {
                        if (value instanceof String) {
                            this.header_ext.setAppid((String)value);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMSXDeliveryCount")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMSXGroupID")) {
                        if (value instanceof String) {
                            this.header_ext.setGroupid((String)value);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMSXGroupSeq")) {
                        if (value instanceof NUMBER) {
                            this.header_ext.setGroupseq(new Integer(((Datum)value).intValue()));
                        } else if (value instanceof String) {
                            try {
                                this.header_ext.setGroupseq(new Integer((String)value));
                            }
                            catch (NumberFormatException nfe) {
                                AQjmsError.throwEx("Failed to set the JMSXGroupSeq property with " + value + ". This property must be a number", (Throwable)nfe);
                            }
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMSXProducerTXID")) {
                        AQjmsError.throwEx(110);
                        break block44;
                    }
                    if (name.equals("JMSXConsumerTXID")) {
                        AQjmsError.throwEx(110);
                        break block44;
                    }
                    if (name.equals("JMSXRcvTimestamp") || name.equals("JMSXRecvTimestamp")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMSXState")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMS_OracleExcpQ")) {
                        if (value instanceof String) {
                            this.excp_queue = (String)value;
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMS_OracleDelay")) {
                        if (value instanceof NUMBER) {
                            this.msg_delay = ((Datum)value).intValue();
                        } else if (value instanceof String) {
                            try {
                                this.msg_delay = Integer.parseInt((String)value);
                            }
                            catch (NumberFormatException nfe) {
                                AQjmsError.throwEx("Failed to set the JMS_OracleDelay property with " + value + ". This property must be a number", (Throwable)nfe);
                            }
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMS_OracleOriginalMessageID")) {
                        AQjmsError.throwEx(110, name);
                        break block44;
                    }
                    if (name.equals("JMS_OracleHeaderOnly")) {
                        AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, "yes");
                        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        break block44;
                    }
                    if (name.equals("JMS_OracleDeliveryMode")) {
                        AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, (String)value);
                        this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        break block44;
                    }
                    if (name.equals("JMS_OracleConnectionID")) {
                        if (value instanceof String) {
                            AQjmsPropDatum prop_datum = new AQjmsPropDatum(27, (String)value);
                            this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    if (name.equals("JMS_OracleTimestamp")) {
                        Object new_value = value;
                        if (value instanceof String) {
                            try {
                                new_value = new NUMBER(Long.parseLong((String)value));
                            }
                            catch (NumberFormatException nfe) {
                                AQjmsError.throwEx("Failed to set the  JMS_OracleTimestamp property with " + value + ". This property must be a number", (Throwable)nfe);
                            }
                        }
                        if (new_value instanceof NUMBER) {
                            AQjmsPropDatum prop_datum = new AQjmsPropDatum(24, (Datum)((NUMBER)new_value));
                            this.insertPropertyIntoTable(this.msg_properties, name, prop_datum);
                        } else {
                            AQjmsError.throwEx(153);
                        }
                        break block44;
                    }
                    AQjmsError.throwEx(140);
                    break block44;
                }
                AQjmsError.throwEx(140);
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.setSystemProperty-sqlex", sql_ex);
                throw sql_ex;
            }
        }
    }

    Object getSystemProperty(String name) throws SQLException {
        Object prop_value;
        block20: {
            prop_value = null;
            Object str_value = null;
            int num_value = 0;
            try {
                if (m_systemProperties.containsKey(name)) {
                    if (name.equals("JMSXUserID")) {
                        prop_value = this.header_ext.getUserid();
                        break block20;
                    }
                    if (name.equals("JMSXAppID")) {
                        prop_value = this.header_ext.getAppid();
                        break block20;
                    }
                    if (name.equals("JMSXDeliveryCount")) {
                        return new NUMBER(this.attempts + 1);
                    }
                    if (name.equals("JMSXGroupID")) {
                        prop_value = this.header_ext.getGroupid();
                        break block20;
                    }
                    if (name.equals("JMSXGroupSeq")) {
                        if (this.header_ext.getGroupseq() != null) {
                            num_value = this.header_ext.getGroupseq();
                            prop_value = new NUMBER(num_value);
                            break block20;
                        }
                        return null;
                    }
                    if (name.equals("JMSXProducerTXID")) {
                        return null;
                    }
                    if (name.equals("JMSXConsumerTXID")) {
                        return null;
                    }
                    if (name.equals("JMSXRcvTimestamp") || name.equals("JMSXRecvTimestamp")) {
                        prop_value = new NUMBER(this.recv_time);
                        break block20;
                    }
                    if (name.equals("JMSXState")) {
                        prop_value = new NUMBER(this.msg_state);
                        break block20;
                    }
                    if (name.equals("JMS_OracleExcpQ")) {
                        prop_value = this.excp_queue;
                        break block20;
                    }
                    if (name.equals("JMS_OracleDelay")) {
                        prop_value = new NUMBER(this.msg_delay);
                        break block20;
                    }
                    if (name.equals("JMS_OracleOriginalMessageID")) {
                        prop_value = this.orig_msg_id == null ? null : "ID:" + RepConversion.bArray2String((byte[])this.orig_msg_id);
                        break block20;
                    }
                    if (name.equals("JMS_OracleHeaderOnly")) {
                        Object prop_datum = this.msg_properties.get(name);
                        prop_value = prop_datum != null ? "yes" : null;
                        break block20;
                    }
                    if (name.equals("JMS_OracleConnectionID")) {
                        AQjmsPropDatum prop_datum = (AQjmsPropDatum)this.msg_properties.get(name);
                        prop_value = prop_datum != null ? prop_datum.getValue() : null;
                        break block20;
                    }
                    if (name.equals("JMS_OracleDeliveryMode")) {
                        Object prop_datum = this.msg_properties.get(name);
                        prop_value = prop_datum != null ? ((AQjmsPropDatum)prop_datum).getStringValue() : null;
                        break block20;
                    }
                    if (name.equals("JMS_OracleTimestamp")) {
                        Object prop_datum = this.msg_properties.get(name);
                        prop_value = prop_datum != null ? ((AQjmsPropDatum)prop_datum).getDatumValue() : null;
                        break block20;
                    }
                    return null;
                }
                return null;
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsMessage.getSystemProperty-sqlex", sql_ex);
                throw sql_ex;
            }
        }
        return prop_value;
    }

    void setReceiveTime(long receive_time) {
        this.recv_time = receive_time;
    }

    void setMessageState(int state) throws JMSException {
        if (state == 0 || state == 1 || state == 2 || state == 3) {
            this.msg_state = state;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsMessage.setMessageState", "Internal error - invalid message state, msg_state: " + state);
            AQjmsError.throwEx(122);
        }
    }

    void setOriginalMessageId(byte[] id) throws JMSException {
        this.orig_msg_id = id;
    }

    void setExceptionQueue(String excp_q) {
        this.excp_queue = excp_q;
    }

    String getExceptionQueue() {
        return this.excp_queue;
    }

    void setDelay(int delay) {
        this.msg_delay = delay;
    }

    int getDelay() {
        return this.msg_delay;
    }

    public void setSignature(AQjmsSignature signature) {
        this.m_signature = signature;
    }

    public AQjmsSignature getSignature() {
        return this.m_signature;
    }

    void setHeaderOnly() {
        this.m_hdrOnly = true;
    }

    boolean isHeaderOnly() {
        return this.m_hdrOnly;
    }

    int getMsgState() {
        return this.msg_state;
    }

    String getMsgStateAsString() {
        if (this.msg_state == 0) {
            return "READY";
        }
        if (this.msg_state == 1) {
            return "WAITING";
        }
        if (this.msg_state == 2) {
            return "PROCESSED";
        }
        return "EXPIRED";
    }

    void checkPropertyName(String name) throws JMSException {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Property name can not be null or empty string");
        }
        this.chkDeprecatedProp(name);
        if (name.length() > 100) {
            AQjmsError.throwEx(148);
        }
    }

    void checkPropertyValue(String name, String value) throws JMSException {
        if (value != null) {
            if (name.equalsIgnoreCase("JMSXAppID") || name.equalsIgnoreCase("JMSXUserID") || name.equalsIgnoreCase("JMSXGroupID") || name.equalsIgnoreCase("JMSXType")) {
                if (value.length() > 100) {
                    AQjmsError.throwEx(165);
                }
            } else if (value.length() > 2000) {
                AQjmsError.throwEx(165);
            }
        }
    }

    void insertPropertyIntoTable(Hashtable table, String name, AQjmsPropDatum value) throws JMSException {
        if (table.size() < 1000) {
            table.put(name, value);
        } else {
            AQjmsError.throwEx(132);
        }
    }

    private static void initSystemPropertyTypeTable() {
        m_systemProperties = new Hashtable();
        m_systemProperties.put("JMSXAppID", m_strClass);
        m_systemProperties.put("JMSXUserID", m_strClass);
        m_systemProperties.put("JMSXRcvTimestamp", m_longClass);
        m_systemProperties.put("JMSXState", m_intClass);
        m_systemProperties.put("JMSXDeliveryCount", m_intClass);
        m_systemProperties.put("JMSXGroupID", m_strClass);
        m_systemProperties.put("JMSXGroupSeq", m_intClass);
        m_systemProperties.put("JMS_OracleExcpQ", m_strClass);
        m_systemProperties.put("JMS_OracleDelay", m_longClass);
        m_systemProperties.put("JMS_OracleOriginalMessageID", m_strClass);
        m_systemProperties.put("JMS_OracleHeaderOnly", m_strClass);
        m_systemProperties.put("JMS_OracleDeliveryMode", m_strClass);
        m_systemProperties.put("JMS_OracleConnectionID", m_strClass);
        m_systemProperties.put("JMS_OracleTimestamp", m_longClass);
        m_settableSystemProperties = new HashSet();
        m_settableSystemProperties.add("JMSXGroupID");
        m_settableSystemProperties.add("JMSXGroupSeq");
    }

    public void printSystemProperties() {
        AQjmsOracleDebug.trace(5, "printSystemProperties", "SYSTEM PROPERTIES");
        try {
            if (this.propertyExists("JMSXAppID")) {
                AQjmsOracleDebug.trace(5, "  JMSXAppID: ", this.getStringProperty("JMSXAppID"));
            }
            if (this.propertyExists("JMSXUserID")) {
                AQjmsOracleDebug.trace(5, "  JMSXUserID: ", this.getStringProperty("JMSXUserID"));
            }
            if (this.propertyExists("JMSXRcvTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXRcvTimestamp: " + this.getLongProperty("JMSXRcvTimestamp"));
            }
            if (this.propertyExists("JMSXState")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXState: " + this.getIntProperty("JMSXState"));
            }
            if (this.propertyExists("JMSXDeliveryCount")) {
                AQjmsOracleDebug.trace(5, "", "  JMSXDeliveryCount: " + this.getIntProperty("JMSXDeliveryCount"));
            }
            if (this.propertyExists("JMSXGroupID")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupID: ", this.getStringProperty("JMSXGroupID"));
            }
            if (this.propertyExists("JMSXGroupSeq")) {
                AQjmsOracleDebug.trace(5, "  JMSXGroupSeq: ", this.getStringProperty("JMSXGroupSeq"));
            }
            if (this.propertyExists("JMS_OracleExcpQ")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleExcpQ: ", this.getStringProperty("JMS_OracleExcpQ"));
            }
            if (this.propertyExists("JMS_OracleDelay")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleDelay: " + this.getLongProperty("JMS_OracleDelay"));
            }
            if (this.propertyExists("JMS_OracleOriginalMessageID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleOriginalMessageID: ", this.getStringProperty("JMS_OracleOriginalMessageID"));
            }
            if (this.propertyExists("JMS_OracleDeliveryMode")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleDeliveryMode: ", this.getStringProperty("JMS_OracleDeliveryMode"));
            }
            if (this.propertyExists("JMS_OracleConnectionID")) {
                AQjmsOracleDebug.trace(5, "  JMS_OracleConnectionID: ", this.getStringProperty("JMS_OracleConnectionID"));
            }
            if (this.propertyExists("JMS_OracleTimestamp")) {
                AQjmsOracleDebug.trace(5, "", "  JMS_OracleTimestamp: " + this.getLongProperty("JMS_OracleTimestamp"));
            }
        }
        catch (JMSException je) {
            AQjmsOracleDebug.trace(5, "PrintSystemPropertied", "Caught JMSException " + (Object)((Object)je));
        }
    }

    private static String serializeDest(AQjmsDestination dest) throws JMSException {
        StringWriter buf = new StringWriter();
        try {
            buf.write("type=" + (dest.isQueue() ? 10 : 20) + "\n");
            buf.write("owner=" + (dest.isQueue() ? dest.getQueueOwner() : dest.getTopicOwner()) + "\n");
            buf.write("name=" + (dest.isQueue() ? dest.getQueueName() : dest.getTopicName()) + "\n");
            buf.write("table=" + dest.getQueueTableName() + "\n");
            buf.write("pload_type=" + dest.getPloadType() + "\n");
            buf.write("adt_type=" + dest.getAdtType() + "\n");
            if (dest.isSecure()) {
                buf.write("secure=true\n");
            } else {
                buf.write("secure=false\n");
            }
            AQjmsDestinationProperty prop = dest.getProperty();
            buf.write("property.queue_type=" + prop.getQueueType() + "\n");
            buf.write("property.max_retries=" + prop.getMaxRetries() + "\n");
            buf.write("property.retry_interval=" + prop.getRetryInterval() + "\n");
            buf.write("property.retention_time=" + prop.getRetentionTime() + "\n");
            buf.write("property.comment=" + prop.getComment() + "\n");
            buf.flush();
        }
        catch (Exception e) {
            AQjmsError.throwEx(147);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AQjmsDestination deserializeDest(String buf) throws JMSException {
        if (buf == null) {
            return null;
        }
        ByteArrayInputStream bi = new ByteArrayInputStream(buf.getBytes());
        AQjmsDestination ret = null;
        boolean sec_flag = false;
        try {
            Properties p = new Properties();
            p.load(bi);
            AQjmsDestinationProperty prop = new AQjmsDestinationProperty();
            prop.setQueueType(Integer.parseInt(p.getProperty("property.queue_type")));
            prop.setMaxRetries(Integer.parseInt(p.getProperty("property.max_retries")));
            prop.setRetryInterval((double)new Double(p.getProperty("property.retry_interval")));
            prop.setRetentionTime((double)new Double(p.getProperty("property.retention_time")));
            prop.setComment(p.getProperty("property.comment"));
            int type = Integer.parseInt(p.getProperty("type"));
            String owner = p.getProperty("owner");
            String name = p.getProperty("name");
            String table = p.getProperty("table");
            int pload_type = Integer.parseInt(p.getProperty("pload_type"));
            String adt_type = p.getProperty("adt_type");
            String sec = p.getProperty("secure");
            if (sec.equalsIgnoreCase("true")) {
                sec_flag = true;
            }
            ret = new AQjmsDestination(owner, name, type, pload_type, adt_type, prop, table, sec_flag);
        }
        catch (Exception e) {
            AQjmsError.throwEx(147);
        }
        finally {
            try {
                if (bi != null) {
                    bi.close();
                }
            }
            catch (Exception ee) {}
        }
        return ret;
    }

    boolean isJMSBody() {
        return this.m_isjmsbody;
    }

    public static int toJMSPriority(int aqp) {
        return 9 - aqp;
    }

    ORAData getMessageCont(AQjmsSession sess, boolean useTemporaryLob) throws JMSException {
        return null;
    }

    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob) throws JMSException {
        return null;
    }

    void writeLob(AQjmsSession jms_sess, String q_table, byte[] msg_id, boolean is_anydata_dest) throws JMSException {
    }

    void messageSendCallback() {
        this.m_writeLobLater = false;
        if (this.m_tempLob != null) {
            try {
                if (this.m_tempLob instanceof BLOB) {
                    ((BLOB)this.m_tempLob).freeTemporary();
                } else {
                    ((CLOB)this.m_tempLob).freeTemporary();
                }
            }
            catch (Exception e) {
                AQjmsOracleDebug.traceEx(1, "AQjmsMessage.freeTemporaryLob", e);
            }
        }
        this.m_tempLob = null;
    }

    boolean getWriteLobLater() {
        return this.m_writeLobLater;
    }

    void setWriteLobLater(boolean value) {
        this.m_writeLobLater = value;
    }

    String chkDeprecatedProp(String prop) throws JMSException {
        if (prop == null) {
            AQjmsError.throwEx(139);
        }
        if ("JMSXRecvTimestamp".equals(prop)) {
            prop = "JMSXRcvTimestamp";
        }
        return prop;
    }

    static {
        AQjmsMessage.initSystemPropertyTypeTable();
    }
}

