/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import oracle.jms.AQjmsError;
import oracle.jms.GenMsgSupport;
import oracle.jms.NormalVersionSupport;
import oracle.jms.VersionSupport;

public class AQjmsInterOp {
    public static final int JMS_ENQU_STMT = 1;
    public static final int ADT_ENQU_STMT = 2;
    public static final int ADT_NOREP_ENQU_STMT = 3;
    public static final int UNSUPPORTED_PARAMETER = -1;
    public static final Map JMS_ENQU_STMT_INDEX = new HashMap();
    public static final Map ADT_ENQU_STMT_INDEX = new HashMap();
    public static final Map ADT_NOREP_ENQU_STMT_INDEX = new HashMap();

    static boolean is82compatible(short dbversion) {
        return dbversion >= 8200;
    }

    static boolean is92compatible(short dbversion) {
        return dbversion >= 9200;
    }

    static boolean hasGenMsgSupport(short dbversion) {
        return dbversion >= 9014 && dbversion < 9200 || dbversion >= 9202;
    }

    static boolean hasTempLobSupport(short dbversion) {
        return dbversion >= 10000;
    }

    static boolean is10compatible(short dbversion) {
        return dbversion >= 10000;
    }

    static boolean is102compatible(short dbversion) {
        return dbversion >= 10200;
    }

    static boolean is11compatible(short dbversion) {
        return dbversion >= 11000;
    }

    static boolean is112compatible(short dbversion) {
        return dbversion >= 11200;
    }

    static String getAddAQNondurableSubStmtByVersion(short dbversion) throws JMSException {
        if (!AQjmsInterOp.is112compatible(dbversion)) {
            AQjmsError.throwEx(102);
        }
        return "begin dbms_aqjms.aq$_add_nondurable_subscriber(?, ?, ?, ?, ?); end;";
    }

    static String getRemoveAQNondurableSubsStmtByVersion(short dbversion) throws JMSException {
        if (!AQjmsInterOp.is112compatible(dbversion)) {
            AQjmsError.throwEx(102);
        }
        return "begin dbms_aqjms.aq$_rem_nondurable_subscriber(?); end;";
    }

    static String getCheckStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is10compatible(dbversion)) {
            return "begin dbms_aqjms.subscriber_exists(?, ?, ?, ?, ?, ?, ?, ?, ?); end;";
        }
        return "begin dbms_aqjms.subscriber_exists(?, ?, ?, ?, ?, ?, ?, ?); end;";
    }

    static String getAddSubStmtByVersion(short dbversion, boolean queueToQueue) throws JMSException {
        if (queueToQueue && !AQjmsInterOp.is11compatible(dbversion)) {
            AQjmsError.throwEx(102);
        }
        if (AQjmsInterOp.is11compatible(dbversion)) {
            return "begin dbms_aqjms.aq$_add_subscriber(queue => ?, subscriber =>?, rule => ?, transformation => ?, secure_q => ?, queue_to_queue => " + queueToQueue + "); end;";
        }
        if (AQjmsInterOp.is92compatible(dbversion)) {
            return "begin dbms_aqjms.aq$_add_subscriber(?, ?, ?, ?, ?); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqjms.aq$_add_subscriber(?, ?, ?, ?); end;";
        }
        return "begin dbms_aqjms.aq$_add_subscriber(?, ?, ?); end;";
    }

    static String getAlterSubStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is92compatible(dbversion)) {
            return "begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?, ?, ?); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?, ?); end;";
        }
        return "begin dbms_aqjms.aq$_alter_subscriber(?, ?, ?); end;";
    }

    static String getRemoveSubStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is92compatible(dbversion)) {
            return "begin dbms_aqjms.aq$_remove_subscriber(?, ?, ?); end;";
        }
        return "begin dbms_aqjms.aq$_remove_subscriber(queue => ?, subscriber => ?); end;";
    }

    static String getEnquTextMsgStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_text_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation=> ?, create_new_lob => ?, delivery_mode =>?); end; ";
        }
        if (AQjmsInterOp.is10compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_text_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation=> ?, create_new_lob => ? ); end; ";
        }
        if (AQjmsInterOp.hasGenMsgSupport(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_text_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation=> ? ); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_text_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ?, signature => ?, transformation=> ? ); end; ";
        }
        return "begin dbms_aqin.aq$_jms_enqueue_text_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, text_message => ?, recipients => ?, msgid => ? ); end; ";
    }

    static String getEnquMapMsgStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_map_message(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ?, delivery_mode =>?); end; ";
        }
        if (AQjmsInterOp.is10compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_map_message(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ? ); end; ";
        }
        if (AQjmsInterOp.hasGenMsgSupport(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_map_message(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_map_message(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ?); end; ";
        }
        return "begin dbms_aqin.aq$_jms_enqueue_map_message(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, map_message => ?, recipients => ?, msgid => ? ); end; ";
    }

    static String getEnquStreamMsgStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_stream_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ?, delivery_mode =>?); end; ";
        }
        if (AQjmsInterOp.is10compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_stream_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ? ); end; ";
        }
        if (AQjmsInterOp.hasGenMsgSupport(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_stream_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_stream_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ?); end; ";
        }
        return "begin dbms_aqin.aq$_jms_enqueue_stream_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, stream_message => ?, recipients => ?, msgid => ? ); end; ";
    }

    static String getEnquBytesMsgStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_bytes_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ?, delivery_mode =>?); end;";
        }
        if (AQjmsInterOp.is10compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_bytes_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ? ); end;";
        }
        if (AQjmsInterOp.hasGenMsgSupport(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_bytes_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ? ); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_bytes_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ? ); end;";
        }
        return "begin dbms_aqin.aq$_jms_enqueue_bytes_message(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, bytes_message => ?, recipients => ?, msgid => ? ); end; ";
    }

    static String getEnquObjectMsgStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_object_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ?, delivery_mode =>?); end;";
        }
        if (AQjmsInterOp.is10compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_object_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ?, create_new_lob => ? ); end;";
        }
        if (AQjmsInterOp.hasGenMsgSupport(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_object_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ?, gen_payload => ?, signature => ?, transformation => ? ); end;";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_jms_enqueue_object_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ?, signature => ?, transformation => ? ); end;";
        }
        return "begin dbms_aqin.aq$_jms_enqueue_object_message(queue_name => ?, sender_name => ?, sender_addr=> ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_message => ?, recipients => ?, msgid => ? ); end; ";
    }

    static String getEnquAdtStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_enqueue_obj(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority=> ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?, signature => ?, transformation => ?, delivery_mode =>?); end; ";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_enqueue_obj(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority=> ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ?, signature => ?, transformation => ? ); end; ";
        }
        return "begin dbms_aqin.aq$_enqueue_obj(queue_name => ?, sender_name => ?, sender_addr => ?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?, priority=> ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, recipients => ? ); end; ";
    }

    static String getEnquAdtNoRecplStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_enqueue_obj_no_recpl(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?,priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, signature => ?, transformation => ?, delivery_mode =>?); end; ";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_enqueue_obj_no_recpl(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?,priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?, signature => ?, transformation => ? ); end; ";
        }
        return "begin dbms_aqin.aq$_enqueue_obj_no_recpl(queue_name => ?, sender_name => ?, sender_addr =>?, sender_protocol => ?, original_msgid => ?, correlation => ?, visibility => ?,priority => ?, delay => ?, expiration=> ?, relative_msgid => ?, sequence_deviation => ?, exception_queue => ?, payload_type => ?, raw_user_data => null, object_user_data => ?, msgid => ?); end; ";
    }

    static String getDequeueStmtByVersion(short dbversion) {
        if (AQjmsInterOp.is102compatible(dbversion)) {
            return "begin dbms_aqin.aq$_dequeue_in(queue_name        => ?, subscriber        => ?, msgid             => ?, correlation       => ?, dequeue_mode      => ?, navigation        => ?, visibility        => ?, wait              => ?, enqueue_time      => ?, state             => ?, out_msgid         => ?, out_correlation   => ?, priority          => ?, delay             => ?, expiration        => ?, attempts          => ?, exception_queue   => ?, remote_recipients => ?, sender_name       => ?, sender_addr       => ?, sender_protocol   => ?, original_msgid    => ?, payload_type      => ?, raw_user_data     => ?, object_user_data  => ?, deq_cond          => ?, signature         => ?, out_sign          => ?, transformation    => ?, delivery_mode     => ?, out_delivery_mode => ?); end; ";
        }
        if (AQjmsInterOp.is82compatible(dbversion)) {
            return "begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ";
        }
        return "begin dbms_aqin.aq$_dequeue_in( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?); end; ";
    }

    static int getEnqueueStmtIndex(short dbversion, int enquStmtType, String paraName) throws JMSException {
        VersionParameter parameter = null;
        switch (enquStmtType) {
            case 1: {
                parameter = (VersionParameter)JMS_ENQU_STMT_INDEX.get(paraName);
                break;
            }
            case 2: {
                parameter = (VersionParameter)ADT_ENQU_STMT_INDEX.get(paraName);
                break;
            }
            case 3: {
                parameter = (VersionParameter)ADT_NOREP_ENQU_STMT_INDEX.get(paraName);
                break;
            }
            default: {
                AQjmsError.throwEx(122, "Invalid enqueue statement type:" + enquStmtType);
            }
        }
        if (parameter == null) {
            return -1;
        }
        if (parameter.vs.support(dbversion)) {
            return parameter.index;
        }
        return -1;
    }

    static {
        JMS_ENQU_STMT_INDEX.put("queue_name", new VersionParameter(1, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("sender_name", new VersionParameter(2, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("sender_addr", new VersionParameter(3, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("sender_protocol", new VersionParameter(4, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("original_msgid", new VersionParameter(5, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("correlation", new VersionParameter(6, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("visibility", new VersionParameter(7, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("priority", new VersionParameter(8, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("delay", new VersionParameter(9, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("expiration", new VersionParameter(10, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("relative_msgid", new VersionParameter(11, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("sequence_deviation", new VersionParameter(12, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("exception_queue", new VersionParameter(13, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("payload_type", new VersionParameter(14, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("jms_message", new VersionParameter(15, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("recipients", new VersionParameter(16, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("msgid", new VersionParameter(17, new NormalVersionSupport(8170)));
        JMS_ENQU_STMT_INDEX.put("gen_payload", new VersionParameter(18, new GenMsgSupport()));
        JMS_ENQU_STMT_INDEX.put("signature", new VersionParameter(19, new NormalVersionSupport(9000)));
        JMS_ENQU_STMT_INDEX.put("transformation", new VersionParameter(20, new NormalVersionSupport(9000)));
        JMS_ENQU_STMT_INDEX.put("create_new_lob", new VersionParameter(21, new NormalVersionSupport(10000)));
        JMS_ENQU_STMT_INDEX.put("delivery_mode", new VersionParameter(22, new NormalVersionSupport(10200)));
        ADT_ENQU_STMT_INDEX.put("queue_name", new VersionParameter(1, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("sender_name", new VersionParameter(2, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("sender_addr", new VersionParameter(3, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("sender_protocol", new VersionParameter(4, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("original_msgid", new VersionParameter(5, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("correlation", new VersionParameter(6, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("visibility", new VersionParameter(7, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("priority", new VersionParameter(8, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("delay", new VersionParameter(9, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("expiration", new VersionParameter(10, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("relative_msgid", new VersionParameter(11, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("sequence_deviation", new VersionParameter(12, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("exception_queue", new VersionParameter(13, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("payload_type", new VersionParameter(14, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("object_user_data", new VersionParameter(15, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("msgid", new VersionParameter(16, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("recipients", new VersionParameter(17, new NormalVersionSupport(8170)));
        ADT_ENQU_STMT_INDEX.put("signature", new VersionParameter(18, new NormalVersionSupport(9000)));
        ADT_ENQU_STMT_INDEX.put("transformation", new VersionParameter(19, new NormalVersionSupport(9000)));
        ADT_ENQU_STMT_INDEX.put("delivery_mode", new VersionParameter(20, new NormalVersionSupport(10200)));
        ADT_NOREP_ENQU_STMT_INDEX.put("queue_name", new VersionParameter(1, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("sender_name", new VersionParameter(2, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("sender_addr", new VersionParameter(3, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("sender_protocol", new VersionParameter(4, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("original_msgid", new VersionParameter(5, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("correlation", new VersionParameter(6, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("visibility", new VersionParameter(7, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("priority", new VersionParameter(8, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("delay", new VersionParameter(9, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("expiration", new VersionParameter(10, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("relative_msgid", new VersionParameter(11, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("sequence_deviation", new VersionParameter(12, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("exception_queue", new VersionParameter(13, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("payload_type", new VersionParameter(14, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("object_user_data", new VersionParameter(15, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("msgid", new VersionParameter(16, new NormalVersionSupport(8170)));
        ADT_NOREP_ENQU_STMT_INDEX.put("signature", new VersionParameter(17, new NormalVersionSupport(9000)));
        ADT_NOREP_ENQU_STMT_INDEX.put("transformation", new VersionParameter(18, new NormalVersionSupport(9000)));
        ADT_NOREP_ENQU_STMT_INDEX.put("delivery_mode", new VersionParameter(19, new NormalVersionSupport(10200)));
    }

    static class VersionParameter {
        int index;
        VersionSupport vs;

        VersionParameter(int index, VersionSupport vs) {
            this.index = index;
            this.vs = vs;
        }
    }
}

