package com.hzjt.config;

import com.hzjt.domain.ResultObj;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.handler.WebSocket;
import com.hzjt.service.EventWriteService;
import com.hzjt.service.TraffFlowService;
import com.hzjt.service.TraffalarmrecordService;
import com.hzjt.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.net.URI;
import java.util.Calendar;
import java.util.List;

@Slf4j
@Component
@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    @Autowired
    TraffFlowService traffFlowService;

    @Autowired
    TraffalarmrecordService traffalarmrecordService;

    @Autowired
    EventWriteService eventWriteService;


    @Scheduled(cron = "0 0 2 * * ? ")//每天凌晨2点执行
    private void statis() {
//        log.info("每天凌晨2点执行前一天数据整合");
//        String date = DateUtils.getYesterday(-1);
        //抽取前一天的车流量和事件统计数据入表
        Integer result = traffFlowService.statisVehiclesByDay();
        //抽取前一天的事件统计到新表中
        Integer resultrecord = traffalarmrecordService.statisTraffalarmrecordstatByDay();

        //删除当天的数据
        traffFlowService.deleteVehiclesByDay();

    }

    @Scheduled(cron = "0 0 23 28-31 * ?")//每一个月执行一次
    private void reconnectWebsocket() {

        final Calendar c = Calendar.getInstance();
        if (c.get(Calendar.DATE) == c.getActualMaximum(Calendar.DATE)) {
//            log.info("每个月最后一天执行删除前2个月车流量数据操作start");
            //删除2个月之前车流量详情的数据
            traffFlowService.deleteBeforeTwoMonthVehicles();
        }
    }


//    @Scheduled(cron = "0 */2 * * * ?")//每2分钟执行一次
    private void sendToguangda() {
        //查询所有未推送的数据
        List<Traffalarmrecord> resultlist=traffalarmrecordService.getTraffalarmrecordBystatus();
        for(Traffalarmrecord record:resultlist)
        {
            try {
                ResultObj obj = eventWriteService.updateAndAutoSendEvent(record);
                if (obj.getStatus() != 200) {
                    log.error(record.getRecordid() + " send to guangda fail");
                } else {
                    log.info(record.getRecordid() + " send to guangda success");
                }
            }catch (Exception  ex){
                log.error(record.getRecordid() + " send to guangda fail"+ex.toString());
            }
        }

    }


//    @Scheduled(cron = "0 30/5 6-19 * * ?")//每隔5分钟统计当天目前为止的数据
//    private void statistoday() {
//        //判断是否为空表
//        //执行查询存在更新，不存在新增
//        log.info("每隔5分钟");
//       Integer result= traffFlowService.insertOrUpdatevehicleTodaystatistic();
//        log.info("today"+result);
//
//    }

}
