package com.hzjt.service;

import com.hzjt.domain.*;
import com.hzjt.mapper.TraffFlowMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
@Slf4j
@Service
public class TraffFlowService {

    @Autowired
    private TraffFlowMapper traffFlowMapper;
    @Autowired
    private RestTemplate restTemplate;

    @Value("${qingzhi.eventwrite.timeout}")
    private Integer timeout;

    @Value("${qingzhi.deviceTraffic.url}")
    private String  url;
    @Autowired
    QingZhiLoginCacheService qingZhiLoginCacheService;

    public void saveTraffFlow(Vehicles vehicles) {
        traffFlowMapper.add(vehicles);
    }

    public int saveTraffFlowDetail(Vehicle vehiclesdetail) {
        return traffFlowMapper.insertlist(vehiclesdetail);
    }

    public List<Map> selectFiveAndDayFlow(String videoid) {
        return traffFlowMapper.selectFiveAndDayFlow(videoid);
    }

    public List<Map> selectFiveAndTypeDayFlow(String videoid) {
        return traffFlowMapper.selectFiveAndTypeDayFlow(videoid);
    }

    public Integer statisVehiclesByDay() {
        return traffFlowMapper.statisVehiclesByDay();
    }


    public void deleteBeforeTwoMonthVehicles() {
        traffFlowMapper.deleteBeforeTwoMonthVehiclesDetails();
    }


    public void deleteVehiclesByDay() {
        traffFlowMapper.deleteVehiclesByDay();
    }

    public Integer insertOrUpdatevehicleTodaystatistic() {
        return traffFlowMapper.insertOrUpdatevehicleTodaystatistic();
    }

    public String selectSbtddspsrRtspByVideoid(String videoid) {

        return traffFlowMapper.selectSbtddspsrRtspByVideoid(videoid);


    }
    public List<VideoDeviceTraffic> getTraffVicleBystatus() {
        return traffFlowMapper.getTraffVicleBystatus();
    }

    public void sendMessage(VideoDeviceTraffic videoDeviceTraffic){
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        //判断token
        String  token= qingZhiLoginCacheService.keepAlive();
        headers.add("token", token);
        HttpEntity<VideoDeviceTraffic> requestEntity = new HttpEntity<>(videoDeviceTraffic, headers);
       try{
        ResultObj obj= CompletableFuture.supplyAsync(() -> restTemplate.postForObject(url, requestEntity, ResultObj.class)).get(timeout,TimeUnit.SECONDS);
    }catch (Exception ex){
        log.error(videoDeviceTraffic.getDeviceId()+videoDeviceTraffic.getDateTime()+":"+ex.toString());
       }
    }

}